/*
 * Decompiled with CFR 0.152.
 */
package com.spacenetwork.icmptunnel;

import com.google.inject.Inject;
import com.snaju.nebula.SpaceSDK;
import com.snaju.nebula.entities.plugin.SpacePlugin;
import com.snaju.nebula.entities.task.NebulaTask;
import com.snaju.nebula.entities.task.TickUnit;
import com.snaju.nebula.entities.task.types.RepeatingTask;
import com.snaju.nebula.service.CommService;
import com.snaju.nebula.service.TaskService;
import com.spacenetwork.leafspace.LeafSpaceSandboxCommAdapter;
import com.spacenetwork.mcs.services.CSPBuilder;
import com.spacenetwork.mcs.services.EnvironmentConfigService;
import com.spacenetwork.mcs.services.RedisService;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public class ICMPTunnelPlugin
extends SpacePlugin {
    private static final String REDIS_TARGET_IP_KEY = "icmp_tunnel_target_ip";
    private String targetRadioIp = "192.168.100.2";
    private static final String VIRTUAL_IP = "10.2.0.1";
    private static final String VIRTUAL_IP_NETWORK = "10.2.0.0/24";
    private static final String SOURCE_IP = "10.10.10.115";
    private static final int CSP_PRIORITY = 1;
    private static final int CSP_SRC_ADDR = 10;
    private static final int CSP_DST_ADDR = 22;
    private static final int CSP_DST_PORT_DEFAULT = 1;
    private int cspDstPort = 1;
    private static final int CSP_SRC_PORT = 54;
    private static final int CSP_FLAGS_DEFAULT = 1;
    private int cspFlags = 1;
    private static final String REDIS_CSP_PORT_KEY = "icmp_tunnel_csp_port";
    private static final String REDIS_CSP_FLAGS_KEY = "icmp_tunnel_csp_flags";
    private static final String TAP_INTERFACE_NAME = "tap_icmp";
    private static final String TAP_GATEWAY_IP = "10.2.0.254";
    private static final int ETHERNET_HEADER_LEN = 14;
    private static final short ETHERTYPE_IPV4 = 2048;
    private static final byte ICMP_PROTOCOL = 1;
    private static final byte ICMP_ECHO_REQUEST = 8;
    private static final byte ICMP_ECHO_REPLY = 0;
    private static final String REDIS_ICMP_OUTPUT = "icmp_tunnel_output";
    private static final String REDIS_ICMP_READY = "icmp_tunnel_ready";
    private TapDevice tap;
    private ExecutorService executor;
    private volatile boolean running = false;
    @Inject
    private EnvironmentConfigService envConfig;
    private final ConcurrentHashMap<String, PendingPing> pendingPings = new ConcurrentHashMap();
    private static final long PING_TIMEOUT_MS = 10000L;
    private final AtomicInteger icmpSequence = new AtomicInteger(0);

    public void onEnable() {
        try {
            System.out.println("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
            System.out.println("\u2551          ICMP TUNNEL PLUGIN STARTING                         \u2551");
            System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
            this.loadTargetIpConfiguration();
            this.loadCspPortConfiguration();
            this.loadCspFlagsConfiguration();
            System.out.println("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
            System.out.println("\u2551  Configuration:                                              \u2551");
            System.out.println("\u2551  Virtual IP: 10.2.0.1 \u2192 Radio: " + this.targetRadioIp);
            System.out.println("\u2551  CSP: Src=10, Dst=22, DstPort=" + this.cspDstPort + ", Flags=" + this.cspFlags);
            System.out.println("\u2551                                                              \u2551");
            System.out.println("\u2551  NOTE: If ping fails, try changing CSP settings via Redis:   \u2551");
            System.out.println("\u2551    SET icmp_tunnel_csp_port <port>  (try: 15, 9, 1, 8)       \u2551");
            System.out.println("\u2551    SET icmp_tunnel_csp_flags <flags> (try: 0, 1)             \u2551");
            System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
            String mode = this.envConfig != null ? this.envConfig.getEnvironmentMode() : "unknown";
            System.out.println("Environment Mode: " + mode);
            if (!"flatsat".equalsIgnoreCase(mode)) {
                System.out.println("\u26a0\ufe0f  ICMP Tunnel Plugin is designed for FlatSat mode only.");
                System.out.println("    Current mode: " + mode);
                System.out.println("    Plugin will still run but may not work as expected.");
            }
            this.setupTap();
            this.running = true;
            this.executor = Executors.newFixedThreadPool(2);
            this.executor.submit(this::uplinkThread);
            this.startResponseMonitor();
            System.out.println("\u2705 ICMP Tunnel Plugin enabled successfully");
            System.out.println("   To test: ping 10.2.0.1");
        }
        catch (Exception e) {
            System.err.println("\u274c Failed to initialize ICMP Tunnel Plugin: " + e.getMessage());
            e.printStackTrace();
            this.onDisable();
        }
    }

    public void onDisable() {
        System.out.println("\ud83d\udd0c ICMP Tunnel Plugin disabling...");
        this.running = false;
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        try {
            this.runCommand("ip", "link", "set", TAP_INTERFACE_NAME, "down");
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("\u2705 ICMP Tunnel Plugin disabled");
    }

    private void setupTap() throws Exception {
        this.tap = new TapDevice(TAP_INTERFACE_NAME);
        this.runCommand("ip", "link", "set", TAP_INTERFACE_NAME, "up");
        this.runCommand("ip", "link", "set", "dev", TAP_INTERFACE_NAME, "mtu", "1400");
        this.runCommand("ip", "addr", "add", "10.2.0.254/24", "dev", TAP_INTERFACE_NAME);
        this.runCommand("ip", "route", "add", VIRTUAL_IP_NETWORK, "dev", TAP_INTERFACE_NAME);
        this.runCommand("sysctl", "-w", "net.ipv6.conf.tap_icmp.disable_ipv6=1");
        String tapMac = this.getTapMacAddress();
        if (tapMac != null) {
            this.runCommand("arp", "-s", VIRTUAL_IP, tapMac, "-i", TAP_INTERFACE_NAME);
        }
        System.out.println("TAP interface configured: tap_icmp");
        System.out.println("  Gateway: 10.2.0.254");
        System.out.println("  Virtual IP: 10.2.0.1 \u2192 " + this.targetRadioIp);
    }

    private String getTapMacAddress() {
        try {
            byte[] mac;
            NetworkInterface nif = NetworkInterface.getByName(TAP_INTERFACE_NAME);
            if (nif != null && (mac = nif.getHardwareAddress()) != null) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02x", mac[i]));
                    if (i >= mac.length - 1) continue;
                    sb.append(":");
                }
                return sb.toString();
            }
        }
        catch (Exception e) {
            System.err.println("Error getting TAP MAC address: " + e.getMessage());
        }
        return "00:00:00:00:00:01";
    }

    private void uplinkThread() {
        block3: {
            System.out.println("\ud83d\udce1 ICMP Uplink Thread Started");
            try {
                while (this.running) {
                    int icmpType;
                    int ipHeaderLen;
                    String dstIp;
                    int protocol;
                    short etherType;
                    byte[] ethFrame = this.tap.readFrame();
                    if (ethFrame == null || ethFrame.length < 14 || (etherType = (short)((ethFrame[12] & 0xFF) << 8 | ethFrame[13] & 0xFF)) != 2048) continue;
                    byte[] ipPacket = new byte[ethFrame.length - 14];
                    System.arraycopy(ethFrame, 14, ipPacket, 0, ipPacket.length);
                    if (ipPacket.length < 20 || (ipPacket[0] & 0xF0) != 64 || (protocol = ipPacket[9] & 0xFF) != 1 || !(dstIp = String.format("%d.%d.%d.%d", ipPacket[16] & 0xFF, ipPacket[17] & 0xFF, ipPacket[18] & 0xFF, ipPacket[19] & 0xFF)).equals(VIRTUAL_IP) || ipPacket.length < (ipHeaderLen = (ipPacket[0] & 0xF) * 4) + 8 || (icmpType = ipPacket[ipHeaderLen] & 0xFF) != 8) continue;
                    int icmpId = (ipPacket[ipHeaderLen + 4] & 0xFF) << 8 | ipPacket[ipHeaderLen + 5] & 0xFF;
                    int icmpSeq = (ipPacket[ipHeaderLen + 6] & 0xFF) << 8 | ipPacket[ipHeaderLen + 7] & 0xFF;
                    byte[] originalSrcIp = new byte[4];
                    System.arraycopy(ipPacket, 12, originalSrcIp, 0, 4);
                    String srcIp = String.format("%d.%d.%d.%d", originalSrcIp[0] & 0xFF, originalSrcIp[1] & 0xFF, originalSrcIp[2] & 0xFF, originalSrcIp[3] & 0xFF);
                    String currentTargetIp = this.readTargetIpFromRedis();
                    System.out.println("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
                    System.out.println("\u2551              ICMP PING REQUEST CAPTURED                      \u2551");
                    System.out.println("\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563");
                    System.out.println("\u2551  From: " + srcIp + " \u2192 To: " + dstIp + " (virtual)");
                    System.out.println("\u2551  ICMP ID: " + icmpId + ", Seq: " + icmpSeq);
                    System.out.println("\u2551  Rewriting to: 10.10.10.115 \u2192 " + currentTargetIp);
                    System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
                    String pingKey = icmpId + ":" + icmpSeq;
                    this.pendingPings.put(pingKey, new PendingPing(icmpId, icmpSeq, originalSrcIp));
                    byte[] modifiedPacket = this.rewriteIpPacket(ipPacket, SOURCE_IP, currentTargetIp);
                    this.sendIcmpViaCsp(modifiedPacket);
                }
            }
            catch (Exception e) {
                if (!this.running) break block3;
                System.err.println("\u274c Uplink thread error: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private byte[] rewriteIpPacket(byte[] ipPacket, String newSrcIp, String newDstIp) throws Exception {
        byte[] modified = (byte[])ipPacket.clone();
        byte[] srcIpBytes = InetAddress.getByName(newSrcIp).getAddress();
        System.arraycopy(srcIpBytes, 0, modified, 12, 4);
        byte[] dstIpBytes = InetAddress.getByName(newDstIp).getAddress();
        System.arraycopy(dstIpBytes, 0, modified, 16, 4);
        this.recalcIpChecksum(modified);
        this.recalcIcmpChecksum(modified);
        return modified;
    }

    private void recalcIpChecksum(byte[] ipPacket) {
        int headerLen = (ipPacket[0] & 0xF) * 4;
        ipPacket[10] = 0;
        ipPacket[11] = 0;
        long sum = 0L;
        for (int i = 0; i < headerLen; i += 2) {
            sum += (long)((ipPacket[i] & 0xFF) << 8 | ipPacket[i + 1] & 0xFF);
        }
        while (sum >> 16 > 0L) {
            sum = (sum & 0xFFFFL) + (sum >> 16);
        }
        int checksum = (int)(sum ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFF;
        ipPacket[10] = (byte)(checksum >> 8 & 0xFF);
        ipPacket[11] = (byte)(checksum & 0xFF);
    }

    private void recalcIcmpChecksum(byte[] ipPacket) {
        int headerLen;
        int icmpStart = headerLen = (ipPacket[0] & 0xF) * 4;
        int icmpLen = ipPacket.length - headerLen;
        ipPacket[icmpStart + 2] = 0;
        ipPacket[icmpStart + 3] = 0;
        long sum = 0L;
        for (int i = 0; i < icmpLen; i += 2) {
            if (i + 1 < icmpLen) {
                sum += (long)((ipPacket[icmpStart + i] & 0xFF) << 8 | ipPacket[icmpStart + i + 1] & 0xFF);
                continue;
            }
            sum += (long)((ipPacket[icmpStart + i] & 0xFF) << 8);
        }
        while (sum >> 16 > 0L) {
            sum = (sum & 0xFFFFL) + (sum >> 16);
        }
        int checksum = (int)(sum ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFF;
        ipPacket[icmpStart + 2] = (byte)(checksum >> 8 & 0xFF);
        ipPacket[icmpStart + 3] = (byte)(checksum & 0xFF);
    }

    private void sendIcmpViaCsp(byte[] ipPacket) {
        try {
            int currentPort = this.readCspPortFromRedis();
            int currentFlags = this.readCspFlagsFromRedis();
            byte[] cspPacket = CSPBuilder.buildCSPPayload((int)1, (int)10, (int)22, (int)currentPort, (int)54, (int)currentFlags, (byte[])ipPacket);
            System.out.println("\ud83d\udce6 CSP Packet built: " + cspPacket.length + " bytes");
            System.out.println("   CSP Header: Pri=1, Src=10, Dst=22, DPort=" + currentPort + ", SPort=" + 54 + ", Flags=" + currentFlags);
            CommService commService = (CommService)SpaceSDK.inject(CommService.class);
            LeafSpaceSandboxCommAdapter sandboxAdapter = (LeafSpaceSandboxCommAdapter)commService.getAdapterOfType(LeafSpaceSandboxCommAdapter.class);
            if (sandboxAdapter == null) {
                System.err.println("\u274c LeafSpace Sandbox adapter not available");
                return;
            }
            sandboxAdapter.sendUplink(1, cspPacket);
            System.out.println("\u2705 ICMP packet sent via MQTT \u2192 WM Server \u2192 Radio");
        }
        catch (Exception e) {
            System.err.println("\u274c Error sending ICMP via CSP: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void startResponseMonitor() {
        ((TaskService)SpaceSDK.inject(TaskService.class)).scheduleTask((NebulaTask)new RepeatingTask("icmp-response-monitor", TickUnit.TICKS.toTicks(1L), TickUnit.TICKS.toTicks(1L), false){

            public void run() {
                try {
                    ICMPTunnelPlugin.this.checkForResponse();
                    ICMPTunnelPlugin.this.cleanupStaleRequests();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        System.out.println("\ud83d\udce1 ICMP Response monitor started (polling Redis for icmp_tunnel_ready)");
    }

    private void checkForResponse() {
        try {
            RedisService redisService = (RedisService)SpaceSDK.inject(RedisService.class);
            if (redisService == null || redisService.getRedisConnection() == null) {
                return;
            }
            if (!redisService.getRedisConnection().isOpen()) {
                return;
            }
            String ready = (String)redisService.getRedisConnection().sync().get((Object)REDIS_ICMP_READY);
            if ("1".equals(ready)) {
                String hexData = (String)redisService.getRedisConnection().sync().get((Object)REDIS_ICMP_OUTPUT);
                if (hexData != null && !hexData.isEmpty()) {
                    this.processIcmpResponse(hexData);
                }
                redisService.getRedisConnection().sync().set((Object)REDIS_ICMP_READY, (Object)"0");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processIcmpResponse(String hexData) {
        try {
            int protocol;
            System.out.println("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
            System.out.println("\u2551              ICMP RESPONSE RECEIVED                          \u2551");
            System.out.println("\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563");
            byte[] responseData = this.hexStringToBytes(hexData);
            System.out.println("\u2551  Raw response: " + responseData.length + " bytes");
            if (responseData.length < 24) {
                System.out.println("\u2551  \u26a0\ufe0f  Response too short, ignoring");
                System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
                return;
            }
            byte[] ipPacket = new byte[responseData.length - 4];
            System.arraycopy(responseData, 4, ipPacket, 0, ipPacket.length);
            if ((ipPacket[0] & 0xF0) != 64) {
                System.out.println("\u2551  \u26a0\ufe0f  Not an IPv4 packet, trying without CSP header skip");
                ipPacket = responseData;
                if ((ipPacket[0] & 0xF0) != 64) {
                    System.out.println("\u2551  \u26a0\ufe0f  Still not IPv4, ignoring");
                    System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
                    return;
                }
            }
            if ((protocol = ipPacket[9] & 0xFF) != 1) {
                System.out.println("\u2551  \u26a0\ufe0f  Not ICMP protocol (" + protocol + "), ignoring");
                System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
                return;
            }
            int ipHeaderLen = (ipPacket[0] & 0xF) * 4;
            int icmpType = ipPacket[ipHeaderLen] & 0xFF;
            int icmpCode = ipPacket[ipHeaderLen + 1] & 0xFF;
            int icmpId = (ipPacket[ipHeaderLen + 4] & 0xFF) << 8 | ipPacket[ipHeaderLen + 5] & 0xFF;
            int icmpSeq = (ipPacket[ipHeaderLen + 6] & 0xFF) << 8 | ipPacket[ipHeaderLen + 7] & 0xFF;
            String srcIp = String.format("%d.%d.%d.%d", ipPacket[12] & 0xFF, ipPacket[13] & 0xFF, ipPacket[14] & 0xFF, ipPacket[15] & 0xFF);
            String dstIp = String.format("%d.%d.%d.%d", ipPacket[16] & 0xFF, ipPacket[17] & 0xFF, ipPacket[18] & 0xFF, ipPacket[19] & 0xFF);
            System.out.println("\u2551  ICMP Type: " + icmpType + " (0=Reply, 8=Request)");
            System.out.println("\u2551  ICMP ID: " + icmpId + ", Seq: " + icmpSeq);
            System.out.println("\u2551  From: " + srcIp + " \u2192 To: " + dstIp);
            String pingKey = icmpId + ":" + icmpSeq;
            PendingPing pending = this.pendingPings.remove(pingKey);
            if (pending == null) {
                System.out.println("\u2551  \u26a0\ufe0f  No matching pending ping found for ID:" + icmpId + " Seq:" + icmpSeq);
                System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
                return;
            }
            String originalSender = String.format("%d.%d.%d.%d", pending.originalSrcIp[0] & 0xFF, pending.originalSrcIp[1] & 0xFF, pending.originalSrcIp[2] & 0xFF, pending.originalSrcIp[3] & 0xFF);
            System.out.println("\u2551  Rewriting: 10.2.0.1 \u2192 " + originalSender);
            byte[] rewrittenPacket = this.rewriteIpPacket(ipPacket, VIRTUAL_IP, originalSender);
            this.injectToTap(rewrittenPacket);
            System.out.println("\u2551  \u2705 ICMP Reply injected to TAP - ping should show success!");
            System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        }
        catch (Exception e) {
            System.err.println("\u274c Error processing ICMP response: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void injectToTap(byte[] ipPacket) throws IOException {
        byte[] ethFrame = new byte[14 + ipPacket.length];
        Arrays.fill(ethFrame, 0, 6, (byte)-1);
        Arrays.fill(ethFrame, 6, 12, (byte)0);
        ethFrame[12] = 8;
        ethFrame[13] = 0;
        System.arraycopy(ipPacket, 0, ethFrame, 14, ipPacket.length);
        this.tap.writeFrame(ethFrame);
    }

    private void cleanupStaleRequests() {
        long now = System.currentTimeMillis();
        this.pendingPings.entrySet().removeIf(entry -> now - ((PendingPing)entry.getValue()).timestamp > 10000L);
    }

    private byte[] hexStringToBytes(String hex) {
        if (hex == null || hex.isEmpty()) {
            return new byte[0];
        }
        if ((hex = hex.replaceAll("\\s+", "").toUpperCase()).length() % 2 != 0) {
            return new byte[0];
        }
        byte[] data = new byte[hex.length() / 2];
        for (int i = 0; i < hex.length(); i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }

    private void runCommand(String ... cmd) throws Exception {
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.inheritIO();
        Process p = pb.start();
        int exitCode = p.waitFor();
        if (exitCode != 0) {
            System.err.println("Command failed with exit code " + exitCode + ": " + String.join((CharSequence)" ", cmd));
        }
    }

    private void loadTargetIpConfiguration() {
        RedisService redisService = null;
        try {
            redisService = (RedisService)SpaceSDK.inject(RedisService.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String redisIp;
            if (redisService != null && redisService.getRedisConnection() != null && redisService.getRedisConnection().isOpen() && (redisIp = (String)redisService.getRedisConnection().sync().get((Object)REDIS_TARGET_IP_KEY)) != null && !redisIp.isEmpty() && this.isValidIp(redisIp)) {
                this.targetRadioIp = redisIp;
                System.out.println("\ud83d\udcdd Target IP loaded from Redis: " + this.targetRadioIp);
                return;
            }
        }
        catch (Exception e) {
            System.out.println("\u26a0\ufe0f  Could not read target IP from Redis: " + e.getMessage());
        }
        String envIp = System.getenv("ICMP_TUNNEL_TARGET_IP");
        if (envIp != null && !envIp.isEmpty() && this.isValidIp(envIp)) {
            this.targetRadioIp = envIp;
            System.out.println("\ud83d\udcdd Target IP loaded from environment variable: " + this.targetRadioIp);
            this.saveToRedis(redisService, REDIS_TARGET_IP_KEY, this.targetRadioIp);
            return;
        }
        System.out.println("\ud83d\udcdd Using default target IP: " + this.targetRadioIp);
        this.saveToRedis(redisService, REDIS_TARGET_IP_KEY, this.targetRadioIp);
    }

    private void saveToRedis(RedisService redisService, String key, String value) {
        try {
            if (redisService != null && redisService.getRedisConnection() != null && redisService.getRedisConnection().isOpen()) {
                redisService.getRedisConnection().sync().set((Object)key, (Object)value);
                System.out.println("\ud83d\udcdd Created/updated Redis key: " + key + " = " + value);
            }
        }
        catch (Exception e) {
            System.out.println("\u26a0\ufe0f  Could not save to Redis key " + key + ": " + e.getMessage());
        }
    }

    private String readTargetIpFromRedis() {
        try {
            String redisIp;
            RedisService redisService = (RedisService)SpaceSDK.inject(RedisService.class);
            if (redisService != null && redisService.getRedisConnection() != null && redisService.getRedisConnection().isOpen() && (redisIp = (String)redisService.getRedisConnection().sync().get((Object)REDIS_TARGET_IP_KEY)) != null && !redisIp.isEmpty() && this.isValidIp(redisIp)) {
                return redisIp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.targetRadioIp;
    }

    private int readCspPortFromRedis() {
        try {
            int port;
            String redisPort;
            RedisService redisService = (RedisService)SpaceSDK.inject(RedisService.class);
            if (redisService != null && redisService.getRedisConnection() != null && redisService.getRedisConnection().isOpen() && (redisPort = (String)redisService.getRedisConnection().sync().get((Object)REDIS_CSP_PORT_KEY)) != null && !redisPort.isEmpty() && (port = Integer.parseInt(redisPort.trim())) >= 0 && port <= 63) {
                return port;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.cspDstPort;
    }

    private int readCspFlagsFromRedis() {
        try {
            int flags;
            String redisFlags;
            RedisService redisService = (RedisService)SpaceSDK.inject(RedisService.class);
            if (redisService != null && redisService.getRedisConnection() != null && redisService.getRedisConnection().isOpen() && (redisFlags = (String)redisService.getRedisConnection().sync().get((Object)REDIS_CSP_FLAGS_KEY)) != null && !redisFlags.isEmpty() && (flags = Integer.parseInt(redisFlags.trim())) >= 0 && flags <= 15) {
                return flags;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.cspFlags;
    }

    private boolean isValidIp(String ip) {
        if (ip == null || ip.isEmpty()) {
            return false;
        }
        String[] parts = ip.split("\\.");
        if (parts.length != 4) {
            return false;
        }
        try {
            for (String part : parts) {
                int num = Integer.parseInt(part);
                if (num >= 0 && num <= 255) continue;
                return false;
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void setTargetRadioIp(String ip) {
        if (!this.isValidIp(ip)) {
            System.err.println("\u274c Invalid IP address: " + ip);
            return;
        }
        this.targetRadioIp = ip;
        System.out.println("\u2705 ICMP Tunnel target IP changed to: " + ip);
        try {
            RedisService redisService = (RedisService)SpaceSDK.inject(RedisService.class);
            if (redisService != null && redisService.getRedisConnection() != null && redisService.getRedisConnection().isOpen()) {
                redisService.getRedisConnection().sync().set((Object)REDIS_TARGET_IP_KEY, (Object)ip);
                System.out.println("\ud83d\udcdd Target IP saved to Redis");
            }
        }
        catch (Exception e) {
            System.err.println("\u26a0\ufe0f  Could not save target IP to Redis: " + e.getMessage());
        }
    }

    public String getTargetRadioIp() {
        return this.targetRadioIp;
    }

    private void loadCspPortConfiguration() {
        int port;
        RedisService redisService = null;
        try {
            redisService = (RedisService)SpaceSDK.inject(RedisService.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String redisPort;
            if (redisService != null && redisService.getRedisConnection() != null && redisService.getRedisConnection().isOpen() && (redisPort = (String)redisService.getRedisConnection().sync().get((Object)REDIS_CSP_PORT_KEY)) != null && !redisPort.isEmpty() && (port = Integer.parseInt(redisPort.trim())) >= 0 && port <= 63) {
                this.cspDstPort = port;
                System.out.println("\ud83d\udcdd CSP destination port loaded from Redis: " + this.cspDstPort);
                return;
            }
        }
        catch (Exception e) {
            System.out.println("\u26a0\ufe0f  Could not read CSP port from Redis: " + e.getMessage());
        }
        String envPort = System.getenv("ICMP_TUNNEL_CSP_PORT");
        if (envPort != null && !envPort.isEmpty()) {
            try {
                port = Integer.parseInt(envPort.trim());
                if (port >= 0 && port <= 63) {
                    this.cspDstPort = port;
                    System.out.println("\ud83d\udcdd CSP destination port loaded from environment variable: " + this.cspDstPort);
                    this.saveToRedis(redisService, REDIS_CSP_PORT_KEY, String.valueOf(this.cspDstPort));
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        System.out.println("\ud83d\udcdd Using default CSP destination port: " + this.cspDstPort);
        this.saveToRedis(redisService, REDIS_CSP_PORT_KEY, String.valueOf(this.cspDstPort));
    }

    public void setCspDstPort(int port) {
        if (port < 0 || port > 63) {
            System.err.println("\u274c Invalid CSP port: " + port + " (must be 0-63)");
            return;
        }
        this.cspDstPort = port;
        System.out.println("\u2705 ICMP Tunnel CSP destination port changed to: " + port);
        try {
            RedisService redisService = (RedisService)SpaceSDK.inject(RedisService.class);
            if (redisService != null && redisService.getRedisConnection() != null && redisService.getRedisConnection().isOpen()) {
                redisService.getRedisConnection().sync().set((Object)REDIS_CSP_PORT_KEY, (Object)String.valueOf(port));
                System.out.println("\ud83d\udcdd CSP port saved to Redis");
            }
        }
        catch (Exception e) {
            System.err.println("\u26a0\ufe0f  Could not save CSP port to Redis: " + e.getMessage());
        }
    }

    public int getCspDstPort() {
        return this.cspDstPort;
    }

    private void loadCspFlagsConfiguration() {
        int flags;
        RedisService redisService = null;
        try {
            redisService = (RedisService)SpaceSDK.inject(RedisService.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String redisFlags;
            if (redisService != null && redisService.getRedisConnection() != null && redisService.getRedisConnection().isOpen() && (redisFlags = (String)redisService.getRedisConnection().sync().get((Object)REDIS_CSP_FLAGS_KEY)) != null && !redisFlags.isEmpty() && (flags = Integer.parseInt(redisFlags.trim())) >= 0 && flags <= 15) {
                this.cspFlags = flags;
                System.out.println("\ud83d\udcdd CSP flags loaded from Redis: " + this.cspFlags);
                return;
            }
        }
        catch (Exception e) {
            System.out.println("\u26a0\ufe0f  Could not read CSP flags from Redis: " + e.getMessage());
        }
        String envFlags = System.getenv("ICMP_TUNNEL_CSP_FLAGS");
        if (envFlags != null && !envFlags.isEmpty()) {
            try {
                flags = Integer.parseInt(envFlags.trim());
                if (flags >= 0 && flags <= 15) {
                    this.cspFlags = flags;
                    System.out.println("\ud83d\udcdd CSP flags loaded from environment variable: " + this.cspFlags);
                    this.saveToRedis(redisService, REDIS_CSP_FLAGS_KEY, String.valueOf(this.cspFlags));
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        System.out.println("\ud83d\udcdd Using default CSP flags: " + this.cspFlags);
        this.saveToRedis(redisService, REDIS_CSP_FLAGS_KEY, String.valueOf(this.cspFlags));
    }

    public void setCspFlags(int flags) {
        if (flags < 0 || flags > 15) {
            System.err.println("\u274c Invalid CSP flags: " + flags + " (must be 0-15)");
            return;
        }
        this.cspFlags = flags;
        System.out.println("\u2705 ICMP Tunnel CSP flags changed to: " + flags);
        try {
            RedisService redisService = (RedisService)SpaceSDK.inject(RedisService.class);
            if (redisService != null && redisService.getRedisConnection() != null && redisService.getRedisConnection().isOpen()) {
                redisService.getRedisConnection().sync().set((Object)REDIS_CSP_FLAGS_KEY, (Object)String.valueOf(flags));
                System.out.println("\ud83d\udcdd CSP flags saved to Redis");
            }
        }
        catch (Exception e) {
            System.err.println("\u26a0\ufe0f  Could not save CSP flags to Redis: " + e.getMessage());
        }
    }

    public int getCspFlags() {
        return this.cspFlags;
    }

    public static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.load((String)"c", CLibrary.class);

        public int ioctl(int var1, long var2, Pointer var4);
    }

    private static class TapDevice {
        private static final int TUNSETIFF = 1074025674;
        private static final short IFF_TAP = 2;
        private static final short IFF_NO_PI = 4096;
        private final FileInputStream in;
        private final FileOutputStream out;
        private final String name;

        public TapDevice(String ifaceName) throws IOException {
            RandomAccessFile tunFile = new RandomAccessFile("/dev/net/tun", "rw");
            int fd = TapDevice.getFd(tunFile.getFD());
            byte[] ifr = new byte[40];
            byte[] nameBytes = ifaceName.getBytes(StandardCharsets.US_ASCII);
            System.arraycopy(nameBytes, 0, ifr, 0, Math.min(nameBytes.length, 15));
            int flags = 4098;
            ifr[16] = (byte)(flags & 0xFF);
            ifr[17] = (byte)(flags >> 8 & 0xFF);
            Memory mem = new Memory((long)ifr.length);
            mem.write(0L, ifr, 0, ifr.length);
            int ret = CLibrary.INSTANCE.ioctl(fd, 1074025674L, (Pointer)mem);
            if (ret < 0) {
                throw new IOException("Failed to create TAP interface");
            }
            this.in = new FileInputStream(tunFile.getFD());
            this.out = new FileOutputStream(tunFile.getFD());
            this.name = ifaceName;
        }

        private static int getFd(FileDescriptor fd) throws IOException {
            try {
                Field field = FileDescriptor.class.getDeclaredField("fd");
                field.setAccessible(true);
                return field.getInt(fd);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IOException("Unable to access FileDescriptor.fd", e);
            }
        }

        public byte[] readFrame() throws IOException {
            byte[] buf = new byte[2048];
            int len = this.in.read(buf);
            if (len < 0) {
                throw new EOFException("TAP read returned EOF");
            }
            byte[] frame = new byte[len];
            System.arraycopy(buf, 0, frame, 0, len);
            return frame;
        }

        public void writeFrame(byte[] frame) throws IOException {
            this.out.write(frame);
            this.out.flush();
        }
    }

    private static class PendingPing {
        final int icmpId;
        final int icmpSeq;
        final byte[] originalSrcIp;
        final long timestamp;

        PendingPing(int icmpId, int icmpSeq, byte[] originalSrcIp) {
            this.icmpId = icmpId;
            this.icmpSeq = icmpSeq;
            this.originalSrcIp = (byte[])originalSrcIp.clone();
            this.timestamp = System.currentTimeMillis();
        }
    }
}

