/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.libs.pyronet.jawnae.pyronet;

import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import lowentry.ue4.classes.sockets.SocketServer;
import lowentry.ue4.library.LowEntry;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroException;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroSelector;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.events.PyroClientListener;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.traffic.ByteStream;

public class PyroClient {
    protected final PyroSelector selector;
    protected final SelectionKey key;
    protected final ByteStream outbound;
    private PyroClientListener listener;
    private boolean doEagerWrite = false;
    private boolean doShutdown = false;

    PyroClient(PyroSelector selector, InetSocketAddress bind, InetSocketAddress host, PyroClientListener listener) throws IOException {
        this(selector, PyroClient.bindAndConfigure(selector, SocketChannel.open(), bind), listener);
        ((SocketChannel)this.key.channel()).connect(host);
    }

    PyroClient(PyroSelector selector, SelectionKey key, PyroClientListener listener) {
        this.listener = listener;
        this.selector = selector;
        this.selector.checkThread();
        this.key = key;
        this.key.attach(this);
        this.outbound = new ByteStream();
    }

    public void setListener(PyroClientListener listener) {
        this.selector.checkThread();
        this.listener = listener;
    }

    public PyroSelector selector() {
        return this.selector;
    }

    public InetSocketAddress getLocalAddress() {
        Socket s = ((SocketChannel)this.key.channel()).socket();
        return (InetSocketAddress)s.getLocalSocketAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        Socket s = ((SocketChannel)this.key.channel()).socket();
        return (InetSocketAddress)s.getRemoteSocketAddress();
    }

    public InetAddress getInetAddress() {
        Socket s = ((SocketChannel)this.key.channel()).socket();
        return s.getInetAddress();
    }

    public void setTimeout(int ms) throws IOException {
        this.selector.checkThread();
        ((SocketChannel)this.key.channel()).socket().setSoTimeout(ms);
    }

    public void setLinger(boolean enabled, int seconds) throws IOException {
        this.selector.checkThread();
        ((SocketChannel)this.key.channel()).socket().setSoLinger(enabled, seconds);
    }

    public void setKeepAlive(boolean enabled) throws IOException {
        this.selector.checkThread();
        ((SocketChannel)this.key.channel()).socket().setKeepAlive(enabled);
    }

    public void setEagerWrite(boolean enabled) {
        this.doEagerWrite = enabled;
    }

    public void writeCopy(ByteBuffer data) throws PyroException {
        this.write(this.selector.copy(data));
    }

    public void write(ByteBuffer data) throws PyroException {
        this.selector.checkThread();
        if (!this.key.isValid()) {
            return;
        }
        if (this.doShutdown) {
            throw new PyroException("shutting down");
        }
        this.outbound.append(data);
        if (this.doEagerWrite) {
            try {
                this.onReadyToWrite();
            }
            catch (NotYetConnectedException exc) {
                this.adjustWriteOp();
            }
            catch (IOException exc) {
                this.onConnectionError(exc);
                this.key.cancel();
            }
        } else {
            this.adjustWriteOp();
        }
    }

    public int flush() {
        int total = 0;
        while (this.outbound.hasData()) {
            int written;
            try {
                written = this.onReadyToWrite();
            }
            catch (IOException exc) {
                written = 0;
            }
            if (written == 0) break;
            total += written;
        }
        return total;
    }

    public int flushOrDie() throws PyroException {
        int total = 0;
        while (this.outbound.hasData()) {
            int written;
            try {
                written = this.onReadyToWrite();
            }
            catch (IOException exc) {
                written = 0;
            }
            if (written == 0) {
                throw new PyroException("failed to flush, wrote " + total + " bytes");
            }
            total += written;
        }
        return total;
    }

    public boolean hasDataEnqueued() {
        this.selector.checkThread();
        return this.outbound.hasData();
    }

    public void shutdown() {
        this.selector.checkThread();
        this.doShutdown = true;
        if (!this.hasDataEnqueued()) {
            this.dropConnection();
        }
    }

    public void dropConnection() {
        this.selector.checkThread();
        if (this.isDisconnected()) {
            return;
        }
        Runnable drop = new Runnable(){

            @Override
            public void run() {
                try {
                    if (PyroClient.this.key.channel().isOpen()) {
                        PyroClient.this.key.channel().close();
                    }
                }
                catch (IOException exc) {
                    PyroClient.this.selector().scheduleTask(this);
                }
            }
        };
        drop.run();
        this.onConnectionError("local");
    }

    public boolean isDisconnected() {
        this.selector.checkThread();
        return !this.key.channel().isOpen();
    }

    void onInterestOp() {
        if (!this.key.isValid()) {
            this.onConnectionError("remote");
        } else {
            try {
                if (this.key.isConnectable()) {
                    this.onReadyToConnect();
                }
                if (this.key.isReadable()) {
                    this.onReadyToRead();
                }
                if (this.key.isWritable()) {
                    this.onReadyToWrite();
                }
            }
            catch (IOException exc) {
                this.onConnectionError(exc);
                this.key.cancel();
            }
        }
    }

    private void onReadyToConnect() throws IOException {
        this.selector.checkThread();
        this.selector.adjustInterestOp(this.key, 8, false);
        ((SocketChannel)this.key.channel()).finishConnect();
        this.listener.connectedClient(this);
    }

    private void onReadyToRead() throws IOException {
        this.selector.checkThread();
        SocketChannel channel = (SocketChannel)this.key.channel();
        ByteBuffer buffer = this.selector.networkBuffer;
        buffer.clear();
        int bytes = channel.read(buffer);
        if (bytes == -1) {
            throw new EOFException();
        }
        buffer.flip();
        this.listener.receivedData(this, buffer);
    }

    private int onReadyToWrite() throws IOException {
        this.selector.checkThread();
        int sent = 0;
        ByteBuffer buffer = this.selector.networkBuffer;
        buffer.clear();
        this.outbound.get(buffer);
        buffer.flip();
        if (buffer.hasRemaining()) {
            SocketChannel channel = (SocketChannel)this.key.channel();
            sent = channel.write(buffer);
        }
        if (sent > 0) {
            this.outbound.discard(sent);
        }
        this.listener.sentData(this, sent);
        this.adjustWriteOp();
        if (this.doShutdown && !this.outbound.hasData()) {
            this.dropConnection();
        }
        return sent;
    }

    void onConnectionError(Object cause) {
        this.selector.checkThread();
        try {
            this.key.channel().close();
        }
        catch (IOException exc) {
            this.selector.scheduleTask(() -> this.onConnectionError(cause));
            return;
        }
        if (SocketServer.IS_DEBUGGING && cause instanceof Throwable) {
            SocketServer.DEBUGGING_PRINTSTREAM.println("[DEBUG] Client received a connection error:");
            SocketServer.DEBUGGING_PRINTSTREAM.println(LowEntry.getStackTrace((Throwable)cause));
        }
        if (cause instanceof ConnectException) {
            this.listener.unconnectableClient(this);
        } else if (cause instanceof EOFException) {
            this.listener.disconnectedClient(this);
        } else if (cause instanceof IOException) {
            this.listener.droppedClient(this, (IOException)cause);
        } else {
            if (!(cause instanceof String)) {
                throw new IllegalStateException((Exception)cause);
            }
            if (cause.equals("local")) {
                this.listener.disconnectedClient(this);
            } else if (cause.equals("remote")) {
                this.listener.droppedClient(this, null);
            } else {
                throw new IllegalStateException("illegal cause: " + cause);
            }
        }
    }

    void adjustWriteOp() {
        this.selector.checkThread();
        boolean interested = this.outbound.hasData();
        this.selector.adjustInterestOp(this.key, 4, interested);
    }

    static final SelectionKey bindAndConfigure(PyroSelector selector, SocketChannel channel, InetSocketAddress bind) throws IOException {
        selector.checkThread();
        channel.socket().bind(bind);
        return PyroClient.configure(selector, channel, true);
    }

    static final SelectionKey configure(PyroSelector selector, SocketChannel channel, boolean connect) throws IOException {
        selector.checkThread();
        channel.configureBlocking(false);
        channel.socket().setSoLinger(false, 0);
        channel.socket().setReuseAddress(true);
        channel.socket().setKeepAlive(true);
        channel.socket().setTcpNoDelay(true);
        channel.socket().setReceiveBufferSize(524288);
        channel.socket().setSendBufferSize(524288);
        int ops = 1;
        if (connect) {
            ops |= 8;
        }
        return selector.register(channel, ops);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAddressText() + "]";
    }

    public final String getAddressText() {
        InetSocketAddress sockaddr = this.getRemoteAddress();
        if (sockaddr == null) {
            if (!this.key.channel().isOpen()) {
                return "closed";
            }
            return "connecting";
        }
        InetAddress inetaddr = sockaddr.getAddress();
        if (inetaddr == null) {
            if (!this.key.channel().isOpen()) {
                return "closed";
            }
            return "connecting";
        }
        return inetaddr.getHostAddress() + ":" + sockaddr.getPort();
    }
}

