/*
 * Decompiled with CFR 0.152.
 */
package com.spacenetwork.ping;

import com.google.inject.Inject;
import com.snaju.nebula.SpaceSDK;
import com.snaju.nebula.entities.plugin.SpacePlugin;
import com.snaju.nebula.entities.task.NebulaTask;
import com.snaju.nebula.entities.task.TickUnit;
import com.snaju.nebula.entities.task.types.RepeatingTask;
import com.snaju.nebula.service.CommService;
import com.snaju.nebula.service.TaskService;
import com.spacenetwork.leafspace.LeafSpaceCommAdapter;
import com.spacenetwork.mcs.entites.comm.obj.PayloadPair;
import com.spacenetwork.mcs.services.EncryptionService;
import com.spacenetwork.mcs.services.RedisService;
import com.spacenetwork.mcs.services.SNCommService;
import fr.devnied.bitlib.BytesUtils;
import io.lettuce.core.api.sync.RedisCommands;
import java.util.Map;
import java.util.function.BiConsumer;

public class PingPlugin
extends SpacePlugin {
    private static final int SATELLITE_ID = 1;
    private static final String PING_PACKET_HEX = "9561b6000000";
    private static final String REDIS_KEY_TX = "ping_tx";
    private static final String REDIS_KEY_RX = "ping_rx";
    @Inject
    private RedisService redis;
    @Inject
    private SNCommService snCommService;
    @Inject
    private EncryptionService encryptionService;
    private BiConsumer<String, byte[]> downlinkListener;

    public void onEnable() {
        System.out.println("\n\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        System.out.println("\u2551               PING PLUGIN STARTING                            \u2551");
        System.out.println("\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563");
        System.out.println("\u2551 Ping Packet: 9561b6000000                                   \u2551");
        System.out.println("\u2551 Target Satellite: SAT-1 (10200)                              \u2551");
        System.out.println("\u2551 Interval: 1 second                                            \u2551");
        System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d\n");
        this.initializeRedisCounters();
        this.registerDownlinkListener();
        ((TaskService)SpaceSDK.inject(TaskService.class)).scheduleTask((NebulaTask)new RepeatingTask("ping-sender", TickUnit.SECONDS.toTicks(1L), TickUnit.SECONDS.toTicks(1L), false){

            public void run() {
                PingPlugin.this.sendPing();
            }
        });
        System.out.println("\u2705 Ping Plugin enabled successfully");
    }

    private void initializeRedisCounters() {
        try {
            RedisService redisService = (RedisService)SpaceSDK.inject(RedisService.class);
            if (redisService == null || redisService.getRedisConnection() == null) {
                System.err.println("\u26a0\ufe0f PingPlugin: Redis not available for initialization");
                return;
            }
            if (!redisService.getRedisConnection().isOpen()) {
                return;
            }
            RedisCommands redis = redisService.getRedisConnection().sync();
            if (redis.get((Object)REDIS_KEY_TX) == null) {
                redis.set((Object)REDIS_KEY_TX, (Object)"0");
                System.out.println("\ud83d\udcca Initialized ping_tx = 0");
            }
            if (redis.get((Object)REDIS_KEY_RX) == null) {
                redis.set((Object)REDIS_KEY_RX, (Object)"0");
                System.out.println("\ud83d\udcca Initialized ping_rx = 0");
            }
        }
        catch (Exception e) {
            System.err.println("\u26a0\ufe0f PingPlugin: Failed to initialize Redis counters: " + e.getMessage());
        }
    }

    private void registerDownlinkListener() {
        CommService commService = (CommService)SpaceSDK.inject(CommService.class);
        if (commService == null) {
            System.err.println("\u274c PingPlugin: CommService is null, cannot register downlink listener");
            return;
        }
        LeafSpaceCommAdapter leafSpaceAdapter = (LeafSpaceCommAdapter)commService.getAdapterOfType(LeafSpaceCommAdapter.class);
        if (leafSpaceAdapter == null) {
            System.err.println("\u274c PingPlugin: LeafSpaceCommAdapter is null, cannot register downlink listener");
            return;
        }
        this.downlinkListener = (satelliteId, encryptedPayload) -> this.handleDownlink((String)satelliteId, (byte[])encryptedPayload);
        leafSpaceAdapter.registerDownlinkListener(this.downlinkListener);
        System.out.println("\ud83d\udce1 PingPlugin: Registered downlink listener for ping responses");
    }

    private void sendPing() {
        try {
            RedisService redisService = (RedisService)SpaceSDK.inject(RedisService.class);
            if (redisService == null || redisService.getRedisConnection() == null) {
                return;
            }
            if (!redisService.getRedisConnection().isOpen()) {
                return;
            }
            CommService commService = (CommService)SpaceSDK.inject(CommService.class);
            if (commService == null) {
                return;
            }
            LeafSpaceCommAdapter leafSpaceAdapter = (LeafSpaceCommAdapter)commService.getAdapterOfType(LeafSpaceCommAdapter.class);
            if (leafSpaceAdapter == null) {
                return;
            }
            byte[] pingPacket = BytesUtils.fromString((String)PING_PACKET_HEX);
            leafSpaceAdapter.sendUplink(1, pingPacket, true);
            RedisCommands redis = redisService.getRedisConnection().sync();
            long txCount = redis.incr((Object)REDIS_KEY_TX);
            System.out.println("\ud83d\udce4 [PING TX #" + txCount + "] Sent to SAT-" + 1 + " | Packet: " + PING_PACKET_HEX + " | Size: " + pingPacket.length + " bytes");
        }
        catch (Exception e) {
            System.err.println("\u274c PingPlugin: Error sending ping: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void handleDownlink(String satelliteId, byte[] encryptedPayload) {
        try {
            int satId = this.mapLeafSpaceIdToInternal(satelliteId);
            if (satId != 1) {
                return;
            }
            System.out.println("\n\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
            System.out.println("\u2551           PING PLUGIN - DOWNLINK RECEIVED                     \u2551");
            System.out.println("\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563");
            System.out.println("\u2551 From SAT-" + satelliteId + " (internal: " + satId + ")");
            System.out.println("\u2551 Size: " + encryptedPayload.length + " bytes (encrypted)");
            System.out.println("\u2551 Raw:  " + BytesUtils.bytesToString((byte[])encryptedPayload));
            System.out.println("\u2560\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2563");
            PayloadPair pair = ((SNCommService)SpaceSDK.inject(SNCommService.class)).getSatPair(satId);
            if (pair == null) {
                System.out.println("\u2551 \u274c No PayloadPair found for satellite ID: " + satId);
                System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d\n");
                return;
            }
            String txKeyHex = PingPlugin.bytesToHex(pair.getTxKey());
            byte[] decryptedFrame = ((EncryptionService)SpaceSDK.inject(EncryptionService.class)).decrypt(encryptedPayload, txKeyHex);
            System.out.println("\u2551 Decrypted frame size: " + decryptedFrame.length + " bytes");
            System.out.println("\u2551 Decrypted raw: " + BytesUtils.bytesToString((byte[])decryptedFrame));
            byte[] actualPayload = this.extractSrs3Payload(decryptedFrame);
            System.out.println("\u2551 Final payload size: " + actualPayload.length + " bytes");
            System.out.println("\u2551 Final payload: " + BytesUtils.bytesToString((byte[])actualPayload));
            RedisService redisService = (RedisService)SpaceSDK.inject(RedisService.class);
            if (redisService != null && redisService.getRedisConnection() != null && redisService.getRedisConnection().isOpen()) {
                RedisCommands redis = redisService.getRedisConnection().sync();
                long rxCount = redis.incr((Object)REDIS_KEY_RX);
                String txStr = (String)redis.get((Object)REDIS_KEY_TX);
                long txCount = txStr != null ? Long.parseLong(txStr) : 0L;
                System.out.println("\u2560\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2563");
                System.out.println("\u2551 \ud83d\udcca PING STATS: TX=" + txCount + " | RX=" + rxCount + " | Success Rate: " + (txCount > 0L ? String.format("%.1f%%", (double)rxCount * 100.0 / (double)txCount) : "N/A"));
            }
            System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d\n");
        }
        catch (Exception e) {
            System.err.println("\u274c PingPlugin: Error processing downlink: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private int mapLeafSpaceIdToInternal(String leafSpaceId) {
        try {
            int lsId = Integer.parseInt(leafSpaceId);
            for (Map.Entry entry : SNCommService.idMaps.entrySet()) {
                if ((Integer)entry.getValue() != lsId) continue;
                return (Integer)entry.getKey();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private byte[] extractSrs3Payload(byte[] decryptedFrame) {
        if (decryptedFrame == null || decryptedFrame.length < 2) {
            return new byte[0];
        }
        int header = (decryptedFrame[0] & 0xFF) << 8 | decryptedFrame[1] & 0xFF;
        int payloadLength = header & 0x7FF;
        int type = header >> 12 & 0xF;
        System.out.println("\u2551 SRS-3 Header: type=" + type + ", length=" + payloadLength);
        if (payloadLength <= 0 || payloadLength > decryptedFrame.length - 2) {
            System.err.println("\u274c Invalid SRS-3 payload length: " + payloadLength);
            return new byte[0];
        }
        byte[] payload = new byte[payloadLength];
        System.arraycopy(decryptedFrame, 2, payload, 0, payloadLength);
        return payload;
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public void onDisable() {
        System.out.println("\ud83d\udd0c Ping Plugin disabling...");
        System.out.println("\u2705 Ping Plugin disabled");
    }
}

