/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.libs.pyronet.jawnae.pyronet;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroClient;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroException;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroSelector;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.addon.PyroSelectorProvider;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.events.PyroServerListener;

public class PyroServer {
    protected final PyroSelector selector;
    public final SelectionKey serverKey;
    private final PyroServerListener listener;
    private PyroSelectorProvider selectorProvider;

    PyroServer(PyroSelector selector, Selector nioSelector, InetSocketAddress endpoint, int backlog, PyroServerListener listener) throws IOException {
        this.listener = listener;
        this.selector = selector;
        this.selector.checkThread();
        ServerSocketChannel ssc = ServerSocketChannel.open();
        ssc.socket().bind(endpoint, backlog);
        ssc.configureBlocking(false);
        this.serverKey = ssc.register(nioSelector, 16);
        this.serverKey.attach(this);
    }

    public PyroSelector selector() {
        return this.selector;
    }

    public InetSocketAddress getLocalAddress() {
        ServerSocket s = ((ServerSocketChannel)this.serverKey.channel()).socket();
        return (InetSocketAddress)s.getLocalSocketAddress();
    }

    public void installSelectorProvider(PyroSelectorProvider selectorProvider) {
        this.selector().checkThread();
        this.selectorProvider = selectorProvider;
    }

    void onInterestOp() {
        if (!this.serverKey.isValid()) {
            throw new PyroException("invalid selection key");
        }
        try {
            if (this.serverKey.isAcceptable()) {
                this.onReadyToAccept();
            }
        }
        catch (IOException exc) {
            throw new IllegalStateException(exc);
        }
    }

    public void close() throws IOException {
        this.selector.checkThread();
        this.serverKey.channel().close();
    }

    private void onReadyToAccept() throws IOException {
        this.selector.checkThread();
        SocketChannel channel = ((ServerSocketChannel)this.serverKey.channel()).accept();
        PyroSelector acceptedClientSelector = this.selectorProvider == null ? this.selector : this.selectorProvider.provideFor(channel);
        if (acceptedClientSelector == this.selector) {
            SelectionKey clientKey = PyroClient.configure(acceptedClientSelector, channel, false);
            PyroClient client = new PyroClient(acceptedClientSelector, clientKey, null);
            this.fireAcceptedClient(client);
        } else {
            acceptedClientSelector.scheduleTask(() -> {
                SelectionKey clientKey;
                try {
                    clientKey = PyroClient.configure(acceptedClientSelector, channel, false);
                }
                catch (IOException exc) {
                    throw new IllegalStateException(exc);
                }
                PyroClient client = new PyroClient(acceptedClientSelector, clientKey, null);
                this.fireAcceptedClient(client);
            });
            acceptedClientSelector.wakeup();
        }
    }

    void fireAcceptedClient(PyroClient client) {
        this.listener.acceptedClient(client);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAddressText() + "]";
    }

    public final String getAddressText() {
        if (!this.serverKey.channel().isOpen()) {
            return "closed";
        }
        InetSocketAddress sockaddr = this.getLocalAddress();
        if (sockaddr == null) {
            return "connecting";
        }
        InetAddress inetaddr = sockaddr.getAddress();
        if (inetaddr == null) {
            return "connecting";
        }
        return inetaddr.getHostAddress() + ":" + sockaddr.getPort();
    }
}

