/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.libs.pyronet.lowentry.pyronet.udp;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroException;
import lowentry.ue4.libs.pyronet.lowentry.pyronet.udp.event.PyroClientUdpListener;

public class PyroClientUdp {
    protected final DatagramChannel channel;
    private final Thread networkThread = Thread.currentThread();
    private final PyroClientUdpListener listener;

    public PyroClientUdp(SocketAddress end, PyroClientUdpListener listener) throws Exception {
        this.listener = listener;
        this.channel = DatagramChannel.open();
        this.channel.configureBlocking(false);
        this.channel.bind(null);
        this.channel.connect(end);
    }

    public void shutdown() {
        try {
            this.channel.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final boolean isNetworkThread() {
        return this.networkThread == Thread.currentThread();
    }

    public final Thread networkThread() {
        return this.networkThread;
    }

    public final void checkThread() {
        if (!this.isNetworkThread()) {
            throw new PyroException("call from outside the network-thread, you must schedule tasks");
        }
    }

    public void write(ByteBuffer buffer) {
        if (buffer == null) {
            return;
        }
        int pos = buffer.position();
        try {
            this.channel.write(buffer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        buffer.position(pos);
    }

    public void listen(ByteBuffer buffer) {
        while (this.receive(buffer)) {
            this.listener.receivedDataUdp(buffer);
        }
    }

    private boolean receive(ByteBuffer buffer) {
        try {
            buffer.clear();
            int result = this.channel.read(buffer);
            if (result <= 0) {
                return false;
            }
            buffer.flip();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getLocalPort() {
        int port = this.channel.socket().getLocalPort();
        if (port <= 0) {
            return 0;
        }
        return port;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAddressText() + "]";
    }

    public final String getAddressText() {
        DatagramSocket sockaddr = this.channel.socket();
        if (sockaddr == null) {
            if (!this.channel.isOpen()) {
                return "closed";
            }
            return "connecting";
        }
        InetAddress inetaddr = sockaddr.getInetAddress();
        if (inetaddr == null) {
            if (!this.channel.isOpen()) {
                return "closed";
            }
            return "connecting";
        }
        return inetaddr.getHostAddress() + ":" + sockaddr.getPort();
    }
}

