/*
 * Decompiled with CFR 0.152.
 */
package com.snaju.nebula.service;

import com.snaju.nebula.SpaceSDK;
import com.snaju.nebula.service.LogServiceOld;
import com.snaju.nebula.service.Service;
import com.snaju.nebula.utils.CliUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;

public class LogService
implements Service<LogService> {
    private static PrintStream defaultOut = null;
    private static PrintStream defaultErr = null;
    private String logFile;
    private PrintStream print;
    private OutputStream stream;
    private int daysToKeep = 3;
    private File currentLog;
    private LinkedList<File> pastLogs = new LinkedList();
    private String logDir = "/var/log/nebula";

    @Override
    public void init() {
        System.out.println("---- Log Service");
        try {
            this.rotate();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void rotate() throws IOException {
        if (defaultOut == null) {
            defaultOut = System.out;
        }
        if (defaultErr == null) {
            defaultErr = System.err;
        }
        System.out.println("Starting Log Rotate...");
        CliUtil.exec("mkdir -p /var/log/nebula");
        if (this.currentLog == null) {
            System.out.println("First Boot... checking for log file.");
            this.currentLog = new File("/var/log/nebula/nebula.log");
            if (!this.currentLog.exists()) {
                System.out.println("Log file does not exist, creating it.");
                Files.createFile(this.currentLog.toPath(), new FileAttribute[0]);
            } else {
                System.out.println("Log file already exist.");
            }
        }
        if (!Files.exists(Paths.get("/var/log/nebula/.rotate", new String[0]), new LinkOption[0])) {
            Files.write(Paths.get("/var/log/nebula/.rotate", new String[0]), String.valueOf(System.currentTimeMillis()).getBytes(), new OpenOption[0]);
        }
        File file = new File("/var/log/nebula/.rotate");
        long createTime = Long.parseLong(new String(Files.readAllBytes(file.toPath())));
        if (TimeUnit.MILLISECONDS.toHours(System.currentTimeMillis() - createTime) >= 24L) {
            System.out.println("Log file older then 24 hours... rotating.");
            Files.delete(Paths.get("/var/log/nebula/.rotate", new String[0]));
            System.setOut(defaultOut);
            System.setErr(defaultErr);
            Files.move(this.currentLog.toPath(), Paths.get("/var/log/nebula/nebula_" + System.currentTimeMillis() + ".log", new String[0]), new CopyOption[0]);
            this.currentLog = null;
            this.rotate();
            return;
        }
        final Pattern regex = Pattern.compile("^nebula\\_([0-9]*)\\.log$");
        File dir = new File("/var/log/nebula");
        File[] list = dir.listFiles();
        if (list == null) {
            return;
        }
        this.pastLogs = new LinkedList();
        for (int i = 0; i < list.length; ++i) {
            Matcher m = regex.matcher(list[i].getName());
            if (!m.find()) continue;
            this.pastLogs.add(list[i]);
        }
        System.out.println("Found " + this.pastLogs.size() + " log files in system...");
        this.pastLogs.sort(new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                long f2Time;
                String file1Name = o1.getName();
                String file2Name = o2.getName();
                Matcher f1Matcher = regex.matcher(file1Name);
                Matcher f2Matcher = regex.matcher(file2Name);
                if (!f1Matcher.find()) {
                    return 0;
                }
                if (!f2Matcher.find()) {
                    return 0;
                }
                long f1Time = Long.parseLong(f1Matcher.group(1));
                if (f1Time > (f2Time = Long.parseLong(f2Matcher.group(1)))) {
                    return -1;
                }
                if (f1Time < f2Time) {
                    return 1;
                }
                return 0;
            }
        });
        System.out.println("Begin Current Logs:");
        for (File ff : this.pastLogs) {
            System.out.println(ff.getName());
        }
        System.out.println("End Current Logs.");
        if (this.pastLogs.size() > 3) {
            System.out.println("Only keeping 3...");
            int i = 0;
            for (File p : this.pastLogs) {
                if (i++ >= this.daysToKeep) {
                    System.out.println("DELETE " + p.getName());
                    p.delete();
                    continue;
                }
                System.out.println("KEEP " + p.getName());
            }
        }
        System.out.println("Log Rotate completed!");
        PrintStream printStream = new PrintStream(Files.newOutputStream(this.currentLog.toPath(), StandardOpenOption.APPEND, StandardOpenOption.WRITE));
        System.out.println("Setting default log handler to NebulaLogger...");
        System.setOut(printStream);
        System.setErr(printStream);
        System.out.println("# Snaju Nebula Runtime Log!");
        System.out.println("# Logging Ready @ " + System.currentTimeMillis() + "...");
        System.out.println("# Welcome to Nebula ;)");
        System.out.println("Logging Ready!");
    }

    @Override
    public String getName() {
        return "Log";
    }

    @Override
    public void register(LogService obj) {
    }

    @Override
    public LogServiceOld getLogger() {
        return SpaceSDK.inject(LogServiceOld.class);
    }

    public static class LogPrintString
    extends PrintStream {
        private File currentLog;

        public LogPrintString(File logFile, OutputStream out) {
            super(out);
            this.currentLog = logFile;
        }

        @Override
        public void println(String x) {
            StringBuilder builder = new StringBuilder();
            DateTime date = new DateTime();
            String timestamp = new SimpleDateFormat("M-d-y k:m:s").format(date);
            builder.append("[").append(timestamp).append("]: ").append(x);
            try {
                Files.write(this.currentLog.toPath(), builder.toString().getBytes(), StandardOpenOption.WRITE, StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            super.println(x);
        }

        @Override
        public void print(String s) {
            StringBuilder builder = new StringBuilder();
            DateTime date = new DateTime();
            String timestamp = new SimpleDateFormat("M-d-y k:m:s").format(date);
            builder.append("[OUT][").append(timestamp).append("]: ").append(s);
            try {
                Files.write(this.currentLog.toPath(), s.getBytes(), StandardOpenOption.WRITE, StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            super.print(s);
        }
    }
}

