/*
 * Decompiled with CFR 0.152.
 */
package com.snaju.nebula.service;

import com.google.inject.Singleton;
import com.snaju.nebula.SpaceSDK;
import com.snaju.nebula.entities.thread.ThreadExceptionHandler;
import com.snaju.nebula.service.LogServiceOld;
import com.snaju.nebula.service.Service;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@Singleton
public class ThreadService
implements Service {
    private ConcurrentHashMap<String, Thread> threads = new ConcurrentHashMap();
    private ExecutorService pool = Executors.newFixedThreadPool(3);
    private LogServiceOld ls = (LogServiceOld)SpaceSDK.getInstance().getInjector().getInstance(LogServiceOld.class);

    public Future queueToPool(Runnable runnable) {
        return this.pool.submit(runnable);
    }

    public void runDedicatedThread(String name, Runnable runnable) {
        Thread t = new Thread(runnable);
        t.setName(name);
        t.setUncaughtExceptionHandler(new ThreadExceptionHandler());
        t.start();
        this.threads.put(t.getName(), t);
        System.out.println(this.ls.info("+Starting Thread with name " + name + " (" + this.threads.size() + " total)"));
    }

    public boolean isRunning(String name) {
        if (this.threads.containsKey(name)) {
            return this.threads.get(name).isAlive() && !this.threads.get(name).isInterrupted();
        }
        return false;
    }

    public boolean killThread(String name) {
        if (this.threads.containsKey(name)) {
            this.threads.get(name).interrupt();
            this.threads.remove(name);
            return true;
        }
        return false;
    }

    @Override
    public void init() {
        System.out.println(this.ls.info("---- Async Thread Service"));
    }

    @Override
    public String getName() {
        return "Thread";
    }

    public void register(Object obj) {
    }

    @Override
    public LogServiceOld getLogger() {
        return this.ls;
    }
}

