/*
 * Decompiled with CFR 0.152.
 */
package com.snaju.nebula.utils;

import com.snaju.nebula.SpaceSDK;
import com.snaju.nebula.service.LogServiceOld;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class Sum {
    private static LogServiceOld ls = (LogServiceOld)SpaceSDK.getInstance().getInjector().getInstance(LogServiceOld.class);

    public static int sum(ByteBuffer bb) {
        int sum = 0;
        while (bb.hasRemaining()) {
            sum = (sum & 1) != 0 ? (sum >> 1) + 32768 : (sum >>= 1);
            sum += bb.get() & 0xFF;
            sum &= 0xFFFF;
        }
        return sum;
    }

    public static void sum(File f) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        FileChannel fc = fis.getChannel();
        int sz = (int)fc.size();
        MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, sz);
        int sum = Sum.sum(bb);
        int kb = (sz + 1023) / 1024;
        String s = Integer.toString(sum);
        System.out.println(ls.info(s + "\t" + kb + "\t" + f));
        fc.close();
    }
}

