/*
 * Decompiled with CFR 0.152.
 */
package io.airbrake.javabrake;

import io.airbrake.javabrake.Notifier;
import io.airbrake.javabrake.RouteBreakDownTimerTask;
import io.airbrake.javabrake.RouteMetric;
import io.airbrake.javabrake.TdigestStatGroup;

class RouteBreakdowns
extends TdigestStatGroup {
    String method;
    String route;
    String responseType;
    String time;

    public RouteBreakdowns(String method, String route, String responseType, String time) {
        this.method = method;
        this.route = route;
        this.responseType = responseType;
        this.time = time;
    }

    static void notify(RouteMetric metrics, String date) {
        if (metrics.groups.size() > 1) {
            RouteBreakdowns routeBreakdowns = new RouteBreakdowns(metrics.method, metrics.route, metrics.contentType, date);
            Notifier.routesBreakdownList.add(routeBreakdowns);
            long msbr = metrics.endTime.getTime() - metrics.startTime.getTime();
            routeBreakdowns.addGroups(msbr, metrics.groups);
            RouteBreakDownTimerTask.start();
        }
    }
}

