/*
 * Decompiled with CFR 0.152.
 */
package net.dartnode.mon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import net.dartnode.mon.DartNodeCore;
import net.dartnode.mon.service.RedisService;

public class IPMonitor {
    public static int ppsLimit = 60000;
    public static int bpsLimit = 62500000;
    public static int flowLimit = 20;
    public static int timeInSeconds = 5;
    public static ConcurrentHashMap<String, Long> timeTracker = new ConcurrentHashMap();
    public static HashSet<String> banned = new HashSet();

    public static void monitorInboundIPs(String to) {
        try {
            JsonObject object;
            HttpResponse<String> r = ((GetRequest)((GetRequest)Unirest.get("http://23.165.104.146:10007/remote_host_counters/{target}").basicAuth("admin", "Snaju1421")).routeParam("target", to)).asString();
            if (r.getStatus() == 200 && (object = JsonParser.parseString(r.getBody()).getAsJsonObject()).has("success") && object.get("success").getAsBoolean()) {
                JsonArray array = object.get("values").getAsJsonArray();
                for (JsonElement e : array) {
                    long diffInSeconds;
                    if (!e.isJsonObject()) continue;
                    JsonObject o = e.getAsJsonObject();
                    String host = o.get("host").getAsString();
                    int pps = o.get("incoming_packets").getAsInt();
                    int bps = o.get("incoming_bytes").getAsInt();
                    int flows = o.get("incoming_flows").getAsInt();
                    boolean overLimit = false;
                    if (pps >= ppsLimit || bps >= bpsLimit || flows >= flowLimit) {
                        overLimit = true;
                    }
                    if (!overLimit) continue;
                    if (!timeTracker.containsKey(host)) {
                        timeTracker.put(host, System.currentTimeMillis());
                        System.out.println("Tracking " + host + " as inbound on " + to);
                    }
                    if ((diffInSeconds = (System.currentTimeMillis() - timeTracker.get(host)) / 1000L) < (long)timeInSeconds || DartNodeCore.get(RedisService.class).getRedisConnection().sync().hexists("ddos_ban_" + to, host).booleanValue()) continue;
                    System.out.println("BAN: " + host + " inbound for " + to);
                    banned.add(host);
                    o.addProperty("action", "ban_remote");
                    o.addProperty("target", to);
                    ((HttpRequestWithBody)Unirest.post("https://api.dartnode.net/fw/ddos/webhook").header("Content-Type", "application/json")).body(o.toString()).asStringAsync();
                }
            }
        }
        catch (UnirestException e) {
            throw new RuntimeException(e);
        }
    }
}

