/*
 * Decompiled with CFR 0.152.
 */
package net.dartnode.mon.fastnetmon;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.Unirest;
import net.dartnode.mon.netflow.NetFlowCollector;

public class FastNetMonAPI {
    private static final String KEY = "Snaju1421";
    private static final String ENDPOINT = "http://23.165.104.146:10007/";
    private static final long TIMEOUT = 1800000L;
    public static Map<String, Long> networkLastSeenMap = new HashMap<String, Long>();

    public static void addNetwork(String cidr) throws Exception {
        String encodedCidr = URLEncoder.encode(cidr, "UTF-8");
        HttpResponse<String> response = ((HttpRequestWithBody)Unirest.put("http://23.165.104.146:10007/main/networks_list/" + encodedCidr).basicAuth("admin", KEY)).asString();
        if (!response.isSuccess()) {
            throw new Exception("Failed to Commit: " + response.getBody());
        }
    }

    public static void removeNetwork(String cidr) throws Exception {
        String encodedCidr = URLEncoder.encode(cidr, "UTF-8");
        HttpResponse<String> response = ((HttpRequestWithBody)Unirest.delete("http://23.165.104.146:10007/main/networks_list/" + encodedCidr).basicAuth("admin", KEY)).asString();
        if (!response.isSuccess()) {
            throw new Exception("Failed to Commit: " + response.getBody());
        }
    }

    public static void commit() throws Exception {
        HttpResponse<String> response = ((HttpRequestWithBody)Unirest.put("http://23.165.104.146:10007/commit").basicAuth("admin", KEY)).asString();
        if (!response.isSuccess()) {
            throw new Exception("Failed to Commit: " + response.getBody());
        }
    }

    public static void bulkUpdateNetworks(JsonArray networks) throws Exception {
        HttpResponse<String> response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.put("http://23.165.104.146:10007/main/networks_list").header("Content-Type", "application/json")).basicAuth("admin", KEY)).body(networks.toString()).asString();
        if (!response.isSuccess()) {
            throw new Exception("Failed to Bulk Update Networks: " + response.getBody());
        }
    }

    public static Set<String> getConfiguredNetworks() {
        HttpResponse<JsonNode> response = ((GetRequest)Unirest.get("http://23.165.104.146:10007/main/networks_list").basicAuth("admin", KEY)).asJson();
        HashSet<String> configuredNetworks = new HashSet<String>();
        if (response.isSuccess()) {
            JsonObject jsonObject = JsonParser.parseString(response.getBody().toString()).getAsJsonObject();
            JsonArray values2 = jsonObject.getAsJsonArray("values");
            for (int i = 0; i < values2.size(); ++i) {
                configuredNetworks.add(values2.get(i).getAsString());
            }
        } else {
            System.err.println("Failed to fetch configured networks: " + response.getStatusText());
        }
        return configuredNetworks;
    }

    public static Integer updateNetworks(Map<String, NetFlowCollector.IPStats> currentNetworks) throws Exception {
        int actions = 0;
        long currentTime = System.currentTimeMillis();
        Set<String> configuredNetworks = FastNetMonAPI.getConfiguredNetworks();
        for (String cidr : configuredNetworks) {
            FastNetMonAPI.removeNetwork(cidr);
            ++actions;
        }
        return actions;
    }
}

