/*
 * Decompiled with CFR 0.152.
 */
package net.dartnode.mon.netflow;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.dartnode.mon.NetworkUtils;

public class NetFlowCollector {
    private static final int PORT = 9996;
    private static final long TIMEOUT = TimeUnit.MINUTES.toMillis(5L);
    private static final int CIDR_PREFIX_LENGTH = 24;
    public static final ConcurrentHashMap<String, IPStats> outgoingIPs = new ConcurrentHashMap();
    public static final ConcurrentHashMap<String, IPStats> outgoingBlocks = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket(9996);
            byte[] buffer = new byte[65536];
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            System.out.println("NetFlow Collector listening on port 9996");
            DatagramSocket finalSocket = socket;
            try {
                while (!finalSocket.isClosed()) {
                    try {
                        finalSocket.receive(packet);
                        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(packet.getData(), 0, packet.getLength()));
                        NetFlowCollector.parseNetFlow(dis, outgoingIPs, outgoingBlocks);
                        long currentTime = System.currentTimeMillis();
                        NetFlowCollector.cleanupOldIPs(outgoingIPs, currentTime);
                        NetFlowCollector.cleanupOldIPs(outgoingBlocks, currentTime);
                    }
                    catch (SocketException e) {
                        if (finalSocket.isClosed()) {
                            break;
                        }
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (finalSocket != null && !finalSocket.isClosed()) {
                    finalSocket.close();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        finally {
            if (socket != null && !socket.isClosed()) {
                socket.close();
            }
        }
    }

    private static void parseNetFlow(DataInputStream dis, Map<String, IPStats> outgoingIPs, Map<String, IPStats> outgoingBlocks) throws IOException {
        int version = dis.readUnsignedShort();
        if (version != 9) {
            throw new IOException("Unsupported NetFlow version: " + version);
        }
        int count = dis.readUnsignedShort();
        long uptime = dis.readInt();
        long unixSecs = dis.readInt();
        long unixNsecs = dis.readInt();
        long flowSequence = dis.readInt();
        int sourceId = dis.readInt();
        for (int i = 0; i < count; ++i) {
            int srcIP = dis.readInt();
            int dstIP = dis.readInt();
            int nextHop = dis.readInt();
            int inputInt = dis.readUnsignedShort();
            int outputInt = dis.readUnsignedShort();
            long packets = dis.readInt();
            long bytes = dis.readInt();
            long first = dis.readInt();
            long last = dis.readInt();
            int srcPort = dis.readUnsignedShort();
            int dstPort = dis.readUnsignedShort();
            int pad1 = dis.readUnsignedByte();
            int tcpFlags = dis.readUnsignedByte();
            int prot = dis.readUnsignedByte();
            int tos = dis.readUnsignedByte();
            int srcAs = dis.readUnsignedShort();
            int dstAs = dis.readUnsignedShort();
            int srcMask = dis.readUnsignedByte();
            int dstMask = dis.readUnsignedByte();
            int pad2 = dis.readUnsignedShort();
            String srcIPStr = InetAddress.getByAddress(NetFlowCollector.intToByteArray(srcIP)).getHostAddress();
            String srcBlock = NetworkUtils.getCIDRBlock(srcIPStr, 24);
            NetFlowCollector.updateIPStats(outgoingIPs, srcIPStr, bytes, packets);
            NetFlowCollector.updateIPStats(outgoingBlocks, srcBlock, bytes, packets);
        }
    }

    private static void updateIPStats(Map<String, IPStats> ipStatsMap, String ip, long bytes, long packets) {
        IPStats stats = ipStatsMap.getOrDefault(ip, new IPStats());
        stats.update(bytes, packets);
        ipStatsMap.put(ip, stats);
    }

    private static void cleanupOldIPs(Map<String, IPStats> ipStatsMap, long currentTime) {
        Iterator<Map.Entry<String, IPStats>> iterator2 = ipStatsMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, IPStats> entry = iterator2.next();
            if (currentTime - entry.getValue().lastSeen <= TIMEOUT) continue;
            iterator2.remove();
        }
    }

    private static byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static class IPStats {
        private long lastSeen = System.currentTimeMillis();
        private long packets = 0L;
        private long bytes = 0L;

        public void update(long bytes, long packets) {
            this.lastSeen = System.currentTimeMillis();
            this.packets += packets;
            this.bytes += bytes;
        }

        public String toString() {
            double mbps = (double)this.bytes * 8.0 / 1000000.0;
            return String.format("PPS: %d, MBPS: %.2f, Last Seen: %d", this.packets, mbps, this.lastSeen);
        }
    }
}

