/*
 * Decompiled with CFR 0.152.
 */
package net.dartnode.mon.sflow;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class SFlowCollector {
    private static final int PORT = 6343;
    private static final long TIMEOUT = TimeUnit.HOURS.toMillis(1L);
    private static final String CIDR_BLOCK = "24";
    public static ConcurrentHashMap<String, IPStats> incomingIPs = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, IPStats> outgoingIPs = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, IPStats> incomingBlocks = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, IPStats> outgoingBlocks = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        DatagramSocket socket = null;
        try {
            try {
                socket = new DatagramSocket(6343);
                byte[] buffer = new byte[65536];
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                System.out.println("sFlow Collector listening on port 6343");
                while (true) {
                    socket.receive(packet);
                    DataInputStream dis = new DataInputStream(new ByteArrayInputStream(packet.getData(), 0, packet.getLength()));
                    SFlowCollector.parseSFlow(dis, incomingIPs, outgoingIPs, incomingBlocks, outgoingBlocks);
                    long currentTime = System.currentTimeMillis();
                    SFlowCollector.cleanupOldIPs(incomingIPs, currentTime);
                    SFlowCollector.cleanupOldIPs(outgoingIPs, currentTime);
                    SFlowCollector.cleanupOldIPs(incomingBlocks, currentTime);
                    SFlowCollector.cleanupOldIPs(outgoingBlocks, currentTime);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (socket != null && !socket.isClosed()) {
                    socket.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (socket != null && !socket.isClosed()) {
                socket.close();
            }
            throw throwable;
        }
    }

    private static void parseSFlow(DataInputStream dis, Map<String, IPStats> incomingIPs, Map<String, IPStats> outgoingIPs, Map<String, IPStats> incomingBlocks, Map<String, IPStats> outgoingBlocks) throws IOException {
        int version = dis.readInt();
        int agentAddressType = dis.readInt();
        byte[] agentAddress = agentAddressType == 1 ? new byte[4] : new byte[16];
        dis.readFully(agentAddress);
        int subAgentId = dis.readInt();
        int sequenceNumber = dis.readInt();
        int uptime = dis.readInt();
        int samplesCount = dis.readInt();
        for (int i = 0; i < samplesCount; ++i) {
            int sampleType = dis.readInt();
            int sampleLength = dis.readInt();
            if (sampleLength > dis.available()) {
                throw new IOException("Sample length exceeds available data");
            }
            byte[] sampleData = new byte[sampleLength];
            dis.readFully(sampleData);
            if (sampleType == 1) {
                SFlowCollector.parseFlowSample(new DataInputStream(new ByteArrayInputStream(sampleData)), incomingIPs, outgoingIPs, incomingBlocks, outgoingBlocks);
                continue;
            }
            if (sampleType != 3) continue;
            SFlowCollector.parseExpandedFlowSample(new DataInputStream(new ByteArrayInputStream(sampleData)), incomingIPs, outgoingIPs, incomingBlocks, outgoingBlocks);
        }
    }

    public static void detectHighPPS() {
        List<Map.Entry<String, IPStats>> highInboundPPS = SFlowCollector.findHighPPS(incomingIPs, 20000L);
        List<Map.Entry<String, IPStats>> highOutboundPPS = SFlowCollector.findHighPPS(outgoingIPs, 20000L);
        List<Map.Entry<String, IPStats>> highInboundBlockPPS = SFlowCollector.findHighPPS(incomingBlocks, 20000L);
        List<Map.Entry<String, IPStats>> highOutboundBlockPPS = SFlowCollector.findHighPPS(outgoingBlocks, 20000L);
        if (!highInboundPPS.isEmpty()) {
            System.out.println("High inbound PPS detected:");
            for (Map.Entry<String, IPStats> entry : highInboundPPS) {
                System.out.println(entry.getKey() + " -> " + String.valueOf(entry.getValue()));
            }
        }
        if (!highOutboundPPS.isEmpty()) {
            System.out.println("High outbound PPS detected:");
            for (Map.Entry<String, IPStats> entry : highOutboundPPS) {
                System.out.println(entry.getKey() + " -> " + String.valueOf(entry.getValue()));
            }
        }
        if (!highInboundBlockPPS.isEmpty()) {
            System.out.println("High inbound block PPS detected:");
            for (Map.Entry<String, IPStats> entry : highInboundBlockPPS) {
                System.out.println(entry.getKey() + " -> " + String.valueOf(entry.getValue()));
            }
        }
        if (!highOutboundBlockPPS.isEmpty()) {
            System.out.println("High outbound block PPS detected:");
            for (Map.Entry<String, IPStats> entry : highOutboundBlockPPS) {
                System.out.println(entry.getKey() + " -> " + String.valueOf(entry.getValue()));
            }
        }
    }

    public static List<Map.Entry<String, IPStats>> findHighPPS(Map<String, IPStats> ipStatsMap, long ppsThreshold) {
        ArrayList<Map.Entry<String, IPStats>> highPPSList = new ArrayList<Map.Entry<String, IPStats>>();
        for (Map.Entry<String, IPStats> entry : ipStatsMap.entrySet()) {
            if (entry.getValue().packets <= ppsThreshold) continue;
            highPPSList.add(entry);
        }
        return highPPSList;
    }

    private static void parseFlowSample(DataInputStream dis, Map<String, IPStats> incomingIPs, Map<String, IPStats> outgoingIPs, Map<String, IPStats> incomingBlocks, Map<String, IPStats> outgoingBlocks) throws IOException {
        int sequenceNumber = dis.readInt();
        int sourceId = dis.readInt();
        int samplingRate = dis.readInt();
        int samplePool = dis.readInt();
        int drops = dis.readInt();
        int inputInterface = dis.readInt();
        int outputInterface = dis.readInt();
        int recordsCount = dis.readInt();
        for (int i = 0; i < recordsCount; ++i) {
            int recordType = dis.readInt();
            int recordLength = dis.readInt();
            if (recordLength > dis.available()) {
                throw new IOException("Record length exceeds available data");
            }
            byte[] recordData = new byte[recordLength];
            dis.readFully(recordData);
            if (recordType != 1) continue;
            SFlowCollector.parseRawPacketHeader(new DataInputStream(new ByteArrayInputStream(recordData)), incomingIPs, outgoingIPs, incomingBlocks, outgoingBlocks, samplingRate);
        }
    }

    private static void parseExpandedFlowSample(DataInputStream dis, Map<String, IPStats> incomingIPs, Map<String, IPStats> outgoingIPs, Map<String, IPStats> incomingBlocks, Map<String, IPStats> outgoingBlocks) throws IOException {
        int sequenceNumber = dis.readInt();
        int sourceIdType = dis.readInt();
        int sourceIdIndex = dis.readInt();
        int samplingRate = dis.readInt();
        int samplePool = dis.readInt();
        int drops = dis.readInt();
        int inputFormat = dis.readInt();
        int inputValue = dis.readInt();
        int outputFormat = dis.readInt();
        int outputValue = dis.readInt();
        int recordsCount = dis.readInt();
        for (int i = 0; i < recordsCount; ++i) {
            int recordType = dis.readInt();
            int recordLength = dis.readInt();
            if (recordLength > dis.available()) {
                throw new IOException("Record length exceeds available data");
            }
            byte[] recordData = new byte[recordLength];
            dis.readFully(recordData);
            if (recordType != 1) continue;
            SFlowCollector.parseRawPacketHeader(new DataInputStream(new ByteArrayInputStream(recordData)), incomingIPs, outgoingIPs, incomingBlocks, outgoingBlocks, samplingRate);
        }
    }

    private static void parseRawPacketHeader(DataInputStream dis, Map<String, IPStats> incomingIPs, Map<String, IPStats> outgoingIPs, Map<String, IPStats> incomingBlocks, Map<String, IPStats> outgoingBlocks, int samplingRate) throws IOException {
        int headerProtocol = dis.readInt();
        int frameLength = dis.readInt();
        int payloadRemoved = dis.readInt();
        int headerLength = dis.readInt();
        if (headerLength > dis.available()) {
            throw new IOException("Header length exceeds available data");
        }
        byte[] headerData = new byte[headerLength];
        dis.readFully(headerData);
        if (headerProtocol == 1) {
            SFlowCollector.parseEthernetHeader(new DataInputStream(new ByteArrayInputStream(headerData)), incomingIPs, outgoingIPs, incomingBlocks, outgoingBlocks, frameLength, samplingRate);
        }
    }

    private static void parseEthernetHeader(DataInputStream dis, Map<String, IPStats> incomingIPs, Map<String, IPStats> outgoingIPs, Map<String, IPStats> incomingBlocks, Map<String, IPStats> outgoingBlocks, int frameLength, int samplingRate) throws IOException {
        dis.skipBytes(12);
        int etherType = dis.readUnsignedShort();
        if (etherType == 2048) {
            SFlowCollector.parseIPv4Header(dis, incomingIPs, outgoingIPs, incomingBlocks, outgoingBlocks, frameLength, samplingRate);
        }
    }

    private static void parseIPv4Header(DataInputStream dis, Map<String, IPStats> incomingIPs, Map<String, IPStats> outgoingIPs, Map<String, IPStats> incomingBlocks, Map<String, IPStats> outgoingBlocks, int frameLength, int samplingRate) throws IOException {
        dis.skipBytes(12);
        byte[] srcIPBytes = new byte[4];
        byte[] dstIPBytes = new byte[4];
        dis.readFully(srcIPBytes);
        dis.readFully(dstIPBytes);
        String srcIP = InetAddress.getByAddress(srcIPBytes).getHostAddress();
        String dstIP = InetAddress.getByAddress(dstIPBytes).getHostAddress();
        SFlowCollector.updateIPStats(incomingIPs, srcIP, frameLength, samplingRate);
        SFlowCollector.updateIPStats(outgoingIPs, dstIP, frameLength, samplingRate);
        String srcBlock = SFlowCollector.getCIDRBlock(srcIP);
        String dstBlock = SFlowCollector.getCIDRBlock(dstIP);
        SFlowCollector.updateIPStats(incomingBlocks, srcBlock, frameLength, samplingRate);
        SFlowCollector.updateIPStats(outgoingBlocks, dstBlock, frameLength, samplingRate);
    }

    private static void updateIPStats(Map<String, IPStats> ipStatsMap, String ip, int frameLength, int samplingRate) {
        IPStats stats = ipStatsMap.getOrDefault(ip, new IPStats());
        stats.update(frameLength, samplingRate);
        ipStatsMap.put(ip, stats);
    }

    private static void cleanupOldIPs(Map<String, IPStats> ipStatsMap, long currentTime) {
        Iterator<Map.Entry<String, IPStats>> iterator2 = ipStatsMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, IPStats> entry = iterator2.next();
            if (currentTime - entry.getValue().lastSeen <= TIMEOUT) continue;
            iterator2.remove();
        }
    }

    private static String getCIDRBlock(String ip) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(ip);
        byte[] addressBytes = inetAddress.getAddress();
        int prefixLength = Integer.parseInt(CIDR_BLOCK);
        int mask = -1 << 32 - prefixLength;
        int ipAsInt = 0;
        for (byte b : addressBytes) {
            ipAsInt = ipAsInt << 8 | b & 0xFF;
        }
        int networkAddress = ipAsInt & mask;
        byte[] networkAddressBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            networkAddressBytes[i] = (byte)(networkAddress >> (3 - i) * 8 & 0xFF);
        }
        InetAddress networkInetAddress = InetAddress.getByAddress(networkAddressBytes);
        return networkInetAddress.getHostAddress() + "/24";
    }

    public static class IPStats {
        private long lastSeen = System.currentTimeMillis();
        private long packets = 0L;
        private long bytes = 0L;
        private int flows = 0;

        public void update(int frameLength, int samplingRate) {
            this.lastSeen = System.currentTimeMillis();
            this.packets += (long)samplingRate;
            this.bytes += (long)(frameLength * samplingRate);
            ++this.flows;
        }

        public String toString() {
            double mbps = (double)this.bytes * 8.0 / 1000000.0;
            return String.format("PPS: %d, MBPS: %.2f, Flows: %d, Last Seen: %d", this.packets, mbps, this.flows, this.lastSeen);
        }
    }
}

