/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze.treewalker.steps.lookup;

import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nl.basjes.collections.PrefixMap;
import nl.basjes.collections.prefixmap.StringPrefixMap;
import nl.basjes.parse.useragent.analyze.treewalker.steps.Step;
import nl.basjes.parse.useragent.analyze.treewalker.steps.WalkList;
import nl.basjes.parse.useragent.yauaa.shaded.org.antlr.v4.runtime.tree.ParseTree;

public class StepIsNotInLookupPrefix
extends Step {
    private final String lookupName;
    private final PrefixMap<String> prefixMap;

    private StepIsNotInLookupPrefix() {
        this.lookupName = null;
        this.prefixMap = null;
    }

    public StepIsNotInLookupPrefix(String lookupName, Map<String, String> prefixList) {
        this.lookupName = lookupName;
        this.prefixMap = new StringPrefixMap<String>(false);
        this.prefixMap.putAll(prefixList);
    }

    public StepIsNotInLookupPrefix(String lookupName, Set<String> prefixSet) {
        this.lookupName = lookupName;
        this.prefixMap = new StringPrefixMap<String>(false);
        prefixSet.forEach(v -> this.prefixMap.put((String)v, ""));
    }

    @Override
    public WalkList.WalkResult walk(@Nonnull ParseTree tree, @Nullable String value) {
        String actualValue = this.getActualValue(tree, value);
        String result = this.prefixMap.getLongestMatch(actualValue);
        if (result != null) {
            return null;
        }
        return this.walkNextStep(tree, actualValue);
    }

    public String toString() {
        return "IsNotInLookupPrefix(@" + this.lookupName + ")";
    }
}

