/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.utils.springframework.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import javax.annotation.Nullable;
import nl.basjes.parse.useragent.utils.springframework.util.ReflectionUtils;

public abstract class VfsUtils {
    private static final String VFS3_PKG = "org.jboss.vfs.";
    private static final String VFS_NAME = "VFS";
    private static final Method VFS_METHOD_GET_ROOT_URL;
    private static final Method VFS_METHOD_GET_ROOT_URI;
    private static final Method VIRTUAL_FILE_METHOD_EXISTS;
    private static final Method VIRTUAL_FILE_METHOD_GET_INPUT_STREAM;
    private static final Method VIRTUAL_FILE_METHOD_GET_SIZE;
    private static final Method VIRTUAL_FILE_METHOD_GET_LAST_MODIFIED;
    private static final Method VIRTUAL_FILE_METHOD_TO_URL;
    private static final Method VIRTUAL_FILE_METHOD_TO_URI;
    private static final Method VIRTUAL_FILE_METHOD_GET_NAME;
    private static final Method VIRTUAL_FILE_METHOD_GET_PATH_NAME;
    private static final Method VIRTUAL_FILE_METHOD_GET_PHYSICAL_FILE;
    private static final Method VIRTUAL_FILE_METHOD_GET_CHILD;
    protected static final Class<?> VIRTUAL_FILE_VISITOR_INTERFACE;
    protected static final Method VIRTUAL_FILE_METHOD_VISIT;
    private static final Field VISITOR_ATTRIBUTES_FIELD_RECURSE;
    private static final boolean VFS_CAN_BE_USED;

    protected static Object invokeVfsMethod(Method method, @Nullable Object target, Object ... args2) throws IOException {
        if (!VFS_CAN_BE_USED) {
            throw new IllegalStateException("Could not detect JBoss VFS infrastructure");
        }
        try {
            return method.invoke(target, args2);
        }
        catch (InvocationTargetException ex) {
            Throwable targetEx = ex.getTargetException();
            if (targetEx instanceof IOException) {
                throw (IOException)targetEx;
            }
            ReflectionUtils.handleInvocationTargetException(ex);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
        }
        throw new IllegalStateException("Invalid code path reached");
    }

    static boolean exists(Object vfsResource) {
        try {
            return (Boolean)VfsUtils.invokeVfsMethod(VIRTUAL_FILE_METHOD_EXISTS, vfsResource, new Object[0]);
        }
        catch (IOException ex) {
            return false;
        }
    }

    static boolean isReadable(Object vfsResource) {
        try {
            return (Long)VfsUtils.invokeVfsMethod(VIRTUAL_FILE_METHOD_GET_SIZE, vfsResource, new Object[0]) > 0L;
        }
        catch (IOException ex) {
            return false;
        }
    }

    static long getSize(Object vfsResource) throws IOException {
        return (Long)VfsUtils.invokeVfsMethod(VIRTUAL_FILE_METHOD_GET_SIZE, vfsResource, new Object[0]);
    }

    static long getLastModified(Object vfsResource) throws IOException {
        return (Long)VfsUtils.invokeVfsMethod(VIRTUAL_FILE_METHOD_GET_LAST_MODIFIED, vfsResource, new Object[0]);
    }

    static InputStream getInputStream(Object vfsResource) throws IOException {
        return (InputStream)VfsUtils.invokeVfsMethod(VIRTUAL_FILE_METHOD_GET_INPUT_STREAM, vfsResource, new Object[0]);
    }

    static URL getURL(Object vfsResource) throws IOException {
        return (URL)VfsUtils.invokeVfsMethod(VIRTUAL_FILE_METHOD_TO_URL, vfsResource, new Object[0]);
    }

    static URI getURI(Object vfsResource) throws IOException {
        return (URI)VfsUtils.invokeVfsMethod(VIRTUAL_FILE_METHOD_TO_URI, vfsResource, new Object[0]);
    }

    static String getName(Object vfsResource) {
        try {
            return (String)VfsUtils.invokeVfsMethod(VIRTUAL_FILE_METHOD_GET_NAME, vfsResource, new Object[0]);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot get resource name", ex);
        }
    }

    static Object getRelative(URL url) throws IOException {
        return VfsUtils.invokeVfsMethod(VFS_METHOD_GET_ROOT_URL, null, url);
    }

    static Object getChild(Object vfsResource, String path) throws IOException {
        return VfsUtils.invokeVfsMethod(VIRTUAL_FILE_METHOD_GET_CHILD, vfsResource, path);
    }

    static File getFile(Object vfsResource) throws IOException {
        return (File)VfsUtils.invokeVfsMethod(VIRTUAL_FILE_METHOD_GET_PHYSICAL_FILE, vfsResource, new Object[0]);
    }

    static Object getRoot(URI url) throws IOException {
        return VfsUtils.invokeVfsMethod(VFS_METHOD_GET_ROOT_URI, null, url);
    }

    protected static Object getRoot(URL url) throws IOException {
        return VfsUtils.invokeVfsMethod(VFS_METHOD_GET_ROOT_URL, null, url);
    }

    @Nullable
    protected static Object doGetVisitorAttributes() {
        return ReflectionUtils.getField(VISITOR_ATTRIBUTES_FIELD_RECURSE, null);
    }

    @Nullable
    protected static String doGetPath(Object resource) {
        return (String)ReflectionUtils.invokeMethod(VIRTUAL_FILE_METHOD_GET_PATH_NAME, resource);
    }

    static {
        Field visitorAttributesFieldRecurse;
        Method virtualFileMethodVisit;
        Class<?> virtualFileVisitorInterface;
        Method virtualFileMethodGetChild;
        Method virtualFileMethodGetPhysicalFile;
        Method virtualFileMethodGetPathName;
        Method virtualFileMethodGetName;
        Method virtualFileMethodToUrl;
        Method virtualFileMethodToUri;
        Method virtualFileMethodGetLastModified;
        Method virtualFileMethodGetSize;
        Method virtualFileMethodGetInputStream;
        Method virtualFileMethodExists;
        Method vfsMethodGetRootUri;
        Method vfsMethodGetRootUrl;
        boolean isUsable = true;
        ClassLoader loader = VfsUtils.class.getClassLoader();
        try {
            Class<?> vfsClass = loader.loadClass("org.jboss.vfs.VFS");
            vfsMethodGetRootUrl = vfsClass.getMethod("getChild", URL.class);
            vfsMethodGetRootUri = vfsClass.getMethod("getChild", URI.class);
            Class<?> virtualFile = loader.loadClass("org.jboss.vfs.VirtualFile");
            virtualFileMethodExists = virtualFile.getMethod("exists", new Class[0]);
            virtualFileMethodGetInputStream = virtualFile.getMethod("openStream", new Class[0]);
            virtualFileMethodGetSize = virtualFile.getMethod("getSize", new Class[0]);
            virtualFileMethodGetLastModified = virtualFile.getMethod("getLastModified", new Class[0]);
            virtualFileMethodToUri = virtualFile.getMethod("toURI", new Class[0]);
            virtualFileMethodToUrl = virtualFile.getMethod("toURL", new Class[0]);
            virtualFileMethodGetName = virtualFile.getMethod("getName", new Class[0]);
            virtualFileMethodGetPathName = virtualFile.getMethod("getPathName", new Class[0]);
            virtualFileMethodGetPhysicalFile = virtualFile.getMethod("getPhysicalFile", new Class[0]);
            virtualFileMethodGetChild = virtualFile.getMethod("getChild", String.class);
            virtualFileVisitorInterface = loader.loadClass("org.jboss.vfs.VirtualFileVisitor");
            virtualFileMethodVisit = virtualFile.getMethod("visit", virtualFileVisitorInterface);
            Class<?> visitorAttributesClass = loader.loadClass("org.jboss.vfs.VisitorAttributes");
            visitorAttributesFieldRecurse = visitorAttributesClass.getField("RECURSE");
        }
        catch (Throwable ex) {
            isUsable = false;
            vfsMethodGetRootUrl = null;
            vfsMethodGetRootUri = null;
            virtualFileMethodExists = null;
            virtualFileMethodGetInputStream = null;
            virtualFileMethodGetSize = null;
            virtualFileMethodGetLastModified = null;
            virtualFileMethodToUri = null;
            virtualFileMethodToUrl = null;
            virtualFileMethodGetName = null;
            virtualFileMethodGetPathName = null;
            virtualFileMethodGetPhysicalFile = null;
            virtualFileMethodGetChild = null;
            virtualFileVisitorInterface = null;
            virtualFileMethodVisit = null;
            visitorAttributesFieldRecurse = null;
        }
        VFS_CAN_BE_USED = isUsable;
        VFS_METHOD_GET_ROOT_URL = vfsMethodGetRootUrl;
        VFS_METHOD_GET_ROOT_URI = vfsMethodGetRootUri;
        VIRTUAL_FILE_METHOD_EXISTS = virtualFileMethodExists;
        VIRTUAL_FILE_METHOD_GET_INPUT_STREAM = virtualFileMethodGetInputStream;
        VIRTUAL_FILE_METHOD_GET_SIZE = virtualFileMethodGetSize;
        VIRTUAL_FILE_METHOD_GET_LAST_MODIFIED = virtualFileMethodGetLastModified;
        VIRTUAL_FILE_METHOD_TO_URI = virtualFileMethodToUri;
        VIRTUAL_FILE_METHOD_TO_URL = virtualFileMethodToUrl;
        VIRTUAL_FILE_METHOD_GET_NAME = virtualFileMethodGetName;
        VIRTUAL_FILE_METHOD_GET_PATH_NAME = virtualFileMethodGetPathName;
        VIRTUAL_FILE_METHOD_GET_PHYSICAL_FILE = virtualFileMethodGetPhysicalFile;
        VIRTUAL_FILE_METHOD_GET_CHILD = virtualFileMethodGetChild;
        VIRTUAL_FILE_VISITOR_INTERFACE = virtualFileVisitorInterface;
        VIRTUAL_FILE_METHOD_VISIT = virtualFileMethodVisit;
        VISITOR_ATTRIBUTES_FIELD_RECURSE = visitorAttributesFieldRecurse;
    }
}

