/*
 * Decompiled with CFR 0.152.
 */
package io.airbrake.javabrake;

import io.airbrake.javabrake.Metrics;
import java.util.Date;

class Span {
    Metrics metric;
    Span parent;
    Date startTime;
    Date endTime;
    String name;
    long dur = 0L;
    int level = 0;

    public Span(Metrics metric, String name, Date startTime) {
        this.metric = metric;
        this.startTime = startTime;
        this.name = name;
    }

    public void init() {
        this.startTime = new Date();
        this.endTime = null;
    }

    public void end(Date endTime) {
        this.endTime = endTime != null ? endTime : new Date();
        this.dur += this.endTime.getTime() - this.metric.spans.get((Object)this.name).startTime.getTime();
        this.metric._inc_group(this.name, this.dur);
        this.metric = null;
    }

    protected void pause() {
        if (this.paused()) {
            return;
        }
        this.dur += new Date().getTime() - this.startTime.getTime();
        this.startTime = null;
    }

    protected boolean paused() {
        return this.startTime == null;
    }

    protected void resume() {
        if (!this.paused()) {
            return;
        }
        this.startTime = new Date();
    }
}

