/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.RedisChannelHandler;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.cluster.AbstractNodeSelection;
import io.lettuce.core.cluster.ClusterConnectionProvider;
import io.lettuce.core.cluster.DynamicNodeSelection;
import io.lettuce.core.cluster.NodeSelectionInvocationHandler;
import io.lettuce.core.cluster.StatefulRedisClusterConnectionImpl;
import io.lettuce.core.cluster.StatefulRedisClusterPubSubConnectionImpl;
import io.lettuce.core.cluster.StaticNodeSelection;
import io.lettuce.core.cluster.api.NodeSelectionSupport;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.internal.AbstractInvocationHandler;
import io.lettuce.core.internal.DefaultMethods;
import io.lettuce.core.internal.Futures;
import io.lettuce.core.internal.TimeoutProvider;
import io.lettuce.core.protocol.RedisCommand;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

class ClusterFutureSyncInvocationHandler<K, V>
extends AbstractInvocationHandler {
    private final StatefulConnection<K, V> connection;
    private final TimeoutProvider timeoutProvider;
    private final Class<?> asyncCommandsInterface;
    private final Class<?> nodeSelectionInterface;
    private final Class<?> nodeSelectionCommandsInterface;
    private final Object asyncApi;
    private final Map<Method, Method> apiMethodCache = new ConcurrentHashMap<Method, Method>(RedisClusterCommands.class.getMethods().length, 1.0f);
    private final Map<Method, Method> connectionMethodCache = new ConcurrentHashMap<Method, Method>(5, 1.0f);
    private final Map<Method, MethodHandle> methodHandleCache = new ConcurrentHashMap<Method, MethodHandle>(5, 1.0f);

    ClusterFutureSyncInvocationHandler(StatefulConnection<K, V> connection, Class<?> asyncCommandsInterface, Class<?> nodeSelectionInterface, Class<?> nodeSelectionCommandsInterface, Object asyncApi) {
        this.connection = connection;
        this.timeoutProvider = new TimeoutProvider(() -> connection.getOptions().getTimeoutOptions(), () -> connection.getTimeout().toNanos());
        this.asyncCommandsInterface = asyncCommandsInterface;
        this.nodeSelectionInterface = nodeSelectionInterface;
        this.nodeSelectionCommandsInterface = nodeSelectionCommandsInterface;
        this.asyncApi = asyncApi;
    }

    @Override
    protected Object handleInvocation(Object proxy, Method method, Object[] args2) throws Throwable {
        try {
            if (method.isDefault()) {
                return this.methodHandleCache.computeIfAbsent(method, ClusterFutureSyncInvocationHandler::lookupDefaultMethod).bindTo(proxy).invokeWithArguments(args2);
            }
            if (method.getName().equals("getConnection") && args2.length > 0) {
                return this.getConnection(method, args2);
            }
            if (method.getName().equals("readonly") && args2.length == 1) {
                return this.nodes((Predicate)args2[0], ClusterConnectionProvider.Intent.READ, false);
            }
            if (method.getName().equals("nodes") && args2.length == 1) {
                return this.nodes((Predicate)args2[0], ClusterConnectionProvider.Intent.WRITE, false);
            }
            if (method.getName().equals("nodes") && args2.length == 2) {
                return this.nodes((Predicate)args2[0], ClusterConnectionProvider.Intent.WRITE, (Boolean)args2[1]);
            }
            Method targetMethod = this.apiMethodCache.computeIfAbsent(method, key -> {
                try {
                    return this.asyncApi.getClass().getMethod(key.getName(), key.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException(e);
                }
            });
            Object result = targetMethod.invoke(this.asyncApi, args2);
            if (result instanceof RedisFuture) {
                RedisFuture command = (RedisFuture)result;
                if (!method.getName().equals("exec") && !method.getName().equals("multi") && this.connection instanceof StatefulRedisConnection && ((StatefulRedisConnection)this.connection).isMulti()) {
                    return null;
                }
                return Futures.awaitOrCancel(command, this.getTimeoutNs(command), TimeUnit.NANOSECONDS);
            }
            return result;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private long getTimeoutNs(RedisFuture<?> command) {
        if (command instanceof RedisCommand) {
            return this.timeoutProvider.getTimeoutNs((RedisCommand)((Object)command));
        }
        return this.connection.getTimeout().toNanos();
    }

    private Object getConnection(Method method, Object[] args2) throws Exception {
        Method targetMethod = this.connectionMethodCache.computeIfAbsent(method, this::lookupMethod);
        Object result = targetMethod.invoke(this.connection, args2);
        if (result instanceof StatefulRedisClusterConnection) {
            StatefulRedisClusterConnection connection = (StatefulRedisClusterConnection)result;
            return connection.sync();
        }
        if (result instanceof StatefulRedisConnection) {
            StatefulRedisConnection connection = (StatefulRedisConnection)result;
            return connection.sync();
        }
        throw new IllegalArgumentException("Cannot call method " + method);
    }

    private Method lookupMethod(Method key) {
        try {
            return this.connection.getClass().getMethod(key.getName(), key.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected Object nodes(Predicate<RedisClusterNode> predicate, ClusterConnectionProvider.Intent intent, boolean dynamic) {
        RedisChannelHandler impl;
        AbstractNodeSelection selection = null;
        if (this.connection instanceof StatefulRedisClusterConnectionImpl) {
            impl = (StatefulRedisClusterConnectionImpl)this.connection;
            selection = dynamic ? new DynamicNodeSelection(((StatefulRedisClusterConnectionImpl)impl).getClusterDistributionChannelWriter(), predicate, intent, StatefulRedisConnection::sync) : new StaticNodeSelection(((StatefulRedisClusterConnectionImpl)impl).getClusterDistributionChannelWriter(), predicate, intent, StatefulRedisConnection::sync);
        }
        if (this.connection instanceof StatefulRedisClusterPubSubConnectionImpl) {
            impl = (StatefulRedisClusterPubSubConnectionImpl)this.connection;
            selection = new StaticNodeSelection(((StatefulRedisClusterPubSubConnectionImpl)impl).getClusterDistributionChannelWriter(), predicate, intent, StatefulRedisConnection::sync);
        }
        NodeSelectionInvocationHandler h2 = new NodeSelectionInvocationHandler((AbstractNodeSelection)selection, this.asyncCommandsInterface, this.timeoutProvider);
        return Proxy.newProxyInstance(NodeSelectionSupport.class.getClassLoader(), new Class[]{this.nodeSelectionCommandsInterface, this.nodeSelectionInterface}, (InvocationHandler)h2);
    }

    private static MethodHandle lookupDefaultMethod(Method method) {
        try {
            return DefaultMethods.lookupMethodHandle(method);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

