/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.protocol;

import io.lettuce.core.protocol.CommandArgs;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class CommandArgsAccessor {
    public static <K, V> ByteBuffer encodeFirstKey(CommandArgs<K, V> commandArgs) {
        for (CommandArgs.SingularArgument singularArgument : commandArgs.singularArguments) {
            if (!(singularArgument instanceof CommandArgs.KeyArgument)) continue;
            return commandArgs.codec.encodeKey(((CommandArgs.KeyArgument)singularArgument).key);
        }
        return null;
    }

    public static <K, V> String getFirstString(CommandArgs<K, V> commandArgs) {
        for (CommandArgs.SingularArgument singularArgument : commandArgs.singularArguments) {
            if (!(singularArgument instanceof CommandArgs.StringArgument)) continue;
            return ((CommandArgs.StringArgument)singularArgument).val;
        }
        return null;
    }

    public static <K, V> char[] getFirstCharArray(CommandArgs<K, V> commandArgs) {
        for (CommandArgs.SingularArgument singularArgument : commandArgs.singularArguments) {
            if (!(singularArgument instanceof CommandArgs.CharArrayArgument)) continue;
            return ((CommandArgs.CharArrayArgument)singularArgument).val;
        }
        return null;
    }

    public static <K, V> List<String> getStringArguments(CommandArgs<K, V> commandArgs) {
        ArrayList<String> args2 = new ArrayList<String>();
        for (CommandArgs.SingularArgument singularArgument : commandArgs.singularArguments) {
            if (!(singularArgument instanceof CommandArgs.StringArgument)) continue;
            args2.add(((CommandArgs.StringArgument)singularArgument).val);
        }
        return args2;
    }

    public static <K, V> List<char[]> getCharArrayArguments(CommandArgs<K, V> commandArgs) {
        ArrayList<char[]> args2 = new ArrayList<char[]>();
        for (CommandArgs.SingularArgument singularArgument : commandArgs.singularArguments) {
            if (singularArgument instanceof CommandArgs.CharArrayArgument) {
                args2.add(((CommandArgs.CharArrayArgument)singularArgument).val);
            }
            if (!(singularArgument instanceof CommandArgs.StringArgument)) continue;
            args2.add(((CommandArgs.StringArgument)singularArgument).val.toCharArray());
        }
        return args2;
    }

    public static <K, V> Long getFirstInteger(CommandArgs<K, V> commandArgs) {
        for (CommandArgs.SingularArgument singularArgument : commandArgs.singularArguments) {
            if (!(singularArgument instanceof CommandArgs.IntegerArgument)) continue;
            return ((CommandArgs.IntegerArgument)singularArgument).val;
        }
        return null;
    }
}

