/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.io.FileInputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kong.unirest.AsyncClient;
import kong.unirest.Cache;
import kong.unirest.CacheManager;
import kong.unirest.Client;
import kong.unirest.CompoundInterceptor;
import kong.unirest.Cookie;
import kong.unirest.DefaultInterceptor;
import kong.unirest.Headers;
import kong.unirest.HttpResponse;
import kong.unirest.Interceptor;
import kong.unirest.JsonObjectMapper;
import kong.unirest.NoopMetric;
import kong.unirest.ObjectMapper;
import kong.unirest.Proxy;
import kong.unirest.UniMetric;
import kong.unirest.UnirestConfigException;
import kong.unirest.UnirestException;
import kong.unirest.Util;
import kong.unirest.apache.ApacheAsyncClient;
import kong.unirest.apache.ApacheClient;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.nio.client.HttpAsyncClient;

public class Config {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    public static final int DEFAULT_MAX_CONNECTIONS = 200;
    public static final int DEFAULT_MAX_PER_ROUTE = 20;
    public static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private Optional<Client> client = Optional.empty();
    private Optional<AsyncClient> asyncClient = Optional.empty();
    private Optional<ObjectMapper> objectMapper = Optional.of(new JsonObjectMapper());
    private List<HttpRequestInterceptor> apacheinterceptors = new ArrayList<HttpRequestInterceptor>();
    private Headers headers;
    private Proxy proxy;
    private int connectionTimeout;
    private int socketTimeout;
    private int maxTotal;
    private int maxPerRoute;
    private boolean followRedirects;
    private boolean cookieManagement;
    private boolean useSystemProperties = true;
    private String defaultResponseEncoding = StandardCharsets.UTF_8.name();
    private Function<Config, AsyncClient> asyncBuilder;
    private Function<Config, Client> clientBuilder;
    private boolean requestCompressionOn = true;
    private boolean automaticRetries;
    private boolean verifySsl = true;
    private boolean addShutdownHook = false;
    private KeyStore keystore;
    private Supplier<String> keystorePassword = () -> null;
    private String cookieSpec;
    private UniMetric metrics = new NoopMetric();
    private long ttl = -1L;
    private SSLContext sslContext;
    private String[] ciphers;
    private String[] protocols;
    private CompoundInterceptor interceptor = new CompoundInterceptor();
    private HostnameVerifier hostnameVerifier;
    private String defaultBaseUrl;
    private CacheManager cache;
    private boolean retry = false;
    private int maxRetries;

    public Config() {
        this.setDefaults();
    }

    private void setDefaults() {
        this.apacheinterceptors.clear();
        this.proxy = null;
        this.cache = null;
        this.headers = new Headers();
        this.connectionTimeout = 10000;
        this.socketTimeout = 60000;
        this.maxTotal = 200;
        this.maxPerRoute = 20;
        this.followRedirects = true;
        this.useSystemProperties = true;
        this.cookieManagement = true;
        this.requestCompressionOn = true;
        this.automaticRetries = true;
        this.verifySsl = true;
        this.keystore = null;
        this.keystorePassword = null;
        this.sslContext = null;
        this.ciphers = null;
        this.protocols = null;
        this.interceptor = new CompoundInterceptor();
        this.retry = false;
        this.maxRetries = 10;
        this.objectMapper = Optional.of(new JsonObjectMapper());
        try {
            this.asyncBuilder = ApacheAsyncClient::new;
            this.clientBuilder = ApacheClient::new;
        }
        catch (BootstrapMethodError e) {
            throw new UnirestException("It looks like you are using an older version of Apache Http Client. \nFor security and performance reasons Unirest requires the most recent version. Please upgrade.", e);
        }
    }

    @Deprecated
    public Config httpClient(HttpClient httpClient) {
        this.client = Optional.of(new ApacheClient(httpClient, this, null));
        return this;
    }

    public Config httpClient(Client httpClient) {
        this.client = Optional.ofNullable(httpClient);
        return this;
    }

    public Config httpClient(Function<Config, Client> httpClient) {
        this.clientBuilder = httpClient;
        return this;
    }

    @Deprecated
    public Config asyncClient(HttpAsyncClient value) {
        this.asyncClient = Optional.of(new ApacheAsyncClient(value, this, null, null));
        return this;
    }

    public Config asyncClient(AsyncClient value) {
        this.asyncClient = Optional.ofNullable(value);
        return this;
    }

    public Config asyncClient(Function<Config, AsyncClient> asyncClientBuilder) {
        this.asyncBuilder = asyncClientBuilder;
        return this;
    }

    public Config proxy(Proxy value) {
        this.validateClientsNotRunning();
        this.proxy = value;
        return this;
    }

    public Config proxy(String host, int port) {
        return this.proxy(new Proxy(host, port));
    }

    public Config proxy(String host, int port, String username, String password) {
        return this.proxy(new Proxy(host, port, username, password));
    }

    public Config setObjectMapper(ObjectMapper om) {
        this.objectMapper = Optional.ofNullable(om);
        return this;
    }

    public Config sslContext(SSLContext ssl) {
        this.verifySecurityConfig(this.keystore);
        this.sslContext = ssl;
        return this;
    }

    public Config hostnameVerifier(HostnameVerifier value) {
        this.hostnameVerifier = value;
        return this;
    }

    public Config ciphers(String ... values2) {
        this.ciphers = values2;
        return this;
    }

    public Config protocols(String ... values2) {
        this.protocols = values2;
        return this;
    }

    private void verifySecurityConfig(Object thing) {
        if (thing != null) {
            throw new UnirestConfigException("You may only configure a SSLContext OR a Keystore, but not both");
        }
    }

    public Config clientCertificateStore(KeyStore store, String password) {
        this.verifySecurityConfig(this.sslContext);
        this.keystore = store;
        this.keystorePassword = () -> password;
        return this;
    }

    public Config clientCertificateStore(String fileLocation, String password) {
        this.verifySecurityConfig(this.sslContext);
        try (FileInputStream keyStoreStream = Util.getFileInputStream(fileLocation);){
            this.keystorePassword = () -> password;
            this.keystore = KeyStore.getInstance("PKCS12");
            this.keystore.load(keyStoreStream, this.keystorePassword.get().toCharArray());
        }
        catch (Exception e) {
            throw new UnirestConfigException(e);
        }
        return this;
    }

    public Config connectTimeout(int inMillies) {
        this.validateClientsNotRunning();
        this.connectionTimeout = inMillies;
        return this;
    }

    public Config socketTimeout(int inMillies) {
        this.validateClientsNotRunning();
        this.socketTimeout = inMillies;
        return this;
    }

    public Config concurrency(int total, int perRoute) {
        this.validateClientsNotRunning();
        this.maxTotal = total;
        this.maxPerRoute = perRoute;
        return this;
    }

    public Config clearDefaultHeaders() {
        this.headers.clear();
        return this;
    }

    public Config setDefaultBasicAuth(String username, String password) {
        this.headers.replace("Authorization", Util.toBasicAuthValue(username, password));
        return this;
    }

    public Config setDefaultHeader(String name, String value) {
        this.headers.replace(name, value);
        return this;
    }

    public Config setDefaultHeader(String name, Supplier<String> value) {
        this.headers.add(name, value);
        return this;
    }

    public Config addDefaultHeader(String name, String value) {
        this.headers.add(name, value);
        return this;
    }

    public Config addDefaultCookie(String name, String value) {
        return this.addDefaultCookie(new Cookie(name, value));
    }

    public Config addDefaultCookie(Cookie cookie) {
        this.headers.cookie(cookie);
        return this;
    }

    public Config instrumentWith(UniMetric metric) {
        this.metrics = metric;
        return this;
    }

    @Deprecated
    public Config errorHandler(Consumer<HttpResponse<?>> consumer) {
        Optional<DefaultInterceptor> df = this.getDefaultInterceptor();
        df.ifPresent(d -> d.setConsumer(consumer));
        df.orElseThrow(() -> new UnirestConfigException("You attempted to set a custom error handler while also overriding the Unirest interceptor.\nplease use the interceptor only. This function is deprecated"));
        return this;
    }

    public Config interceptor(Interceptor value) {
        Objects.requireNonNull(value, "Interceptor may not be null");
        this.interceptor.register(value);
        return this;
    }

    @Deprecated
    public Config addInterceptor(HttpRequestInterceptor value) {
        this.validateClientsNotRunning();
        this.apacheinterceptors.add(value);
        return this;
    }

    public Config followRedirects(boolean enable) {
        this.validateClientsNotRunning();
        this.followRedirects = enable;
        return this;
    }

    public Config enableCookieManagement(boolean enable) {
        this.validateClientsNotRunning();
        this.cookieManagement = enable;
        return this;
    }

    public Config verifySsl(boolean value) {
        this.verifySsl = value;
        return this;
    }

    public Config useSystemProperties(boolean value) {
        this.useSystemProperties = value;
        return this;
    }

    public Config requestCompression(boolean value) {
        this.requestCompressionOn = value;
        return this;
    }

    public Config automaticRetries(boolean value) {
        this.automaticRetries = value;
        return this;
    }

    public Config cookieSpec(String policy) {
        this.cookieSpec = policy;
        return this;
    }

    public Config cacheResponses(boolean value) {
        this.cache = value ? new CacheManager() : null;
        return this;
    }

    public Config cacheResponses(Cache.Builder value) {
        this.cache = value.build();
        return this;
    }

    public Config setDefaultResponseEncoding(String value) {
        Objects.requireNonNull(value, "Encoding cannot be null");
        this.defaultResponseEncoding = value;
        return this;
    }

    public Config connectionTTL(long duration, TimeUnit unit) {
        this.ttl = unit.toMillis(duration);
        return this;
    }

    public Config retryAfter(boolean value) {
        return this.retryAfter(value, 10);
    }

    public Config retryAfter(boolean value, int maxRetryAttempts) {
        this.retry = value;
        this.maxRetries = maxRetryAttempts;
        return this;
    }

    public Config connectionTTL(Duration duration) {
        this.ttl = duration.toMillis();
        return this;
    }

    public Config addShutdownHook(boolean value) {
        this.addShutdownHook = value;
        if (value) {
            this.client.ifPresent(Client::registerShutdownHook);
            this.asyncClient.ifPresent(AsyncClient::registerShutdownHook);
        }
        return this;
    }

    public Config defaultBaseUrl(String value) {
        this.defaultBaseUrl = value;
        return this;
    }

    public Headers getDefaultHeaders() {
        return this.headers;
    }

    public boolean isRunning() {
        return this.client.isPresent() || this.asyncClient.isPresent();
    }

    public Config reset() {
        this.shutDown(false);
        return this;
    }

    public void shutDown(boolean clearOptions) {
        List<Exception> ex = Stream.concat(this.client.map(Client::close).orElseGet(Stream::empty), this.asyncClient.map(AsyncClient::close).orElseGet(Stream::empty)).collect(Collectors.toList());
        this.client = Optional.empty();
        this.asyncClient = Optional.empty();
        if (clearOptions) {
            this.setDefaults();
        }
        if (!ex.isEmpty()) {
            throw new UnirestException(ex);
        }
    }

    public Client getClient() {
        if (!this.client.isPresent()) {
            this.buildClient();
        }
        return this.getFinalClient();
    }

    private Client getFinalClient() {
        if (this.cache == null) {
            return this.client.get();
        }
        return this.cache.wrap(this.client.get());
    }

    private synchronized void buildClient() {
        if (!this.client.isPresent()) {
            this.client = Optional.of(this.clientBuilder.apply(this));
        }
    }

    public AsyncClient getAsyncClient() {
        if (!this.asyncClientIsReady()) {
            this.buildAsyncClient();
        }
        return this.getFinalAsyncClient();
    }

    private AsyncClient getFinalAsyncClient() {
        if (this.cache == null) {
            return this.asyncClient.get();
        }
        return this.cache.wrapAsync(this.asyncClient.get());
    }

    private boolean asyncClientIsReady() {
        return this.asyncClient.map(AsyncClient::isRunning).orElse(false);
    }

    private synchronized void buildAsyncClient() {
        if (!this.asyncClientIsReady()) {
            AsyncClient value = this.asyncBuilder.apply(this);
            this.verifyIsOn(value);
            this.asyncClient = Optional.of(value);
        }
    }

    private void verifyIsOn(AsyncClient value) {
        if (!value.isRunning()) {
            throw new UnirestConfigException("Attempted to get a new async client but it was not started. Please ensure it is");
        }
    }

    public boolean getEnabledCookieManagement() {
        return this.cookieManagement;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public int getMaxConnections() {
        return this.maxTotal;
    }

    public int getMaxPerRoutes() {
        return this.maxPerRoute;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public KeyStore getKeystore() {
        return this.keystore;
    }

    public String getKeyStorePassword() {
        return this.keystorePassword.get();
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper.orElseThrow(() -> new UnirestConfigException("No Object Mapper Configured. Please config one with Unirest.config().setObjectMapper"));
    }

    private void validateClientsNotRunning() {
        if (this.client.isPresent() || this.asyncClient.isPresent()) {
            throw new UnirestConfigException("Http Clients are already built in order to build a new config execute Unirest.config().reset() before changing settings. \nThis should be done rarely.");
        }
    }

    @Deprecated
    public List<HttpRequestInterceptor> getInterceptor() {
        return this.apacheinterceptors;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public boolean useSystemProperties() {
        return this.useSystemProperties;
    }

    public String getDefaultResponseEncoding() {
        return this.defaultResponseEncoding;
    }

    public boolean isRequestCompressionOn() {
        return this.requestCompressionOn;
    }

    public boolean isAutomaticRetries() {
        return this.automaticRetries;
    }

    public boolean isVerifySsl() {
        return this.verifySsl;
    }

    public boolean shouldAddShutdownHook() {
        return this.addShutdownHook;
    }

    public String getCookieSpec() {
        return this.cookieSpec;
    }

    public UniMetric getMetric() {
        return this.metrics;
    }

    public long getTTL() {
        return this.ttl;
    }

    public Interceptor getUniInterceptor() {
        return this.interceptor;
    }

    @Deprecated
    public Consumer<HttpResponse<?>> getErrorHandler() {
        return this.getDefaultInterceptor().map(DefaultInterceptor::getConsumer).orElseGet(() -> r -> {});
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    private Optional<DefaultInterceptor> getDefaultInterceptor() {
        return this.interceptor.getInterceptors().stream().filter(i -> i instanceof DefaultInterceptor).map(i -> (DefaultInterceptor)i).findFirst();
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public String[] getCiphers() {
        return this.ciphers;
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public String getDefaultBaseUrl() {
        return this.defaultBaseUrl;
    }

    public boolean isAutomaticRetryAfter() {
        return this.retry;
    }

    public int maxRetries() {
        return this.maxRetries;
    }
}

