/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.apache;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.function.Function;
import kong.unirest.BasicResponse;
import kong.unirest.Headers;
import kong.unirest.HttpResponse;
import kong.unirest.Proxy;
import kong.unirest.RawResponse;
import kong.unirest.UnirestException;
import kong.unirest.UnrecoverableException;
import kong.unirest.apache.DefaultFactory;
import kong.unirest.apache.RequestConfigFactory;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.util.InetAddressUtils;
import org.apache.http.impl.client.BasicCredentialsProvider;

abstract class BaseApacheClient {
    protected RequestConfigFactory configFactory = new DefaultFactory();

    BaseApacheClient() {
    }

    static CredentialsProvider toApacheCreds(Proxy proxy) {
        if (proxy != null && proxy.isAuthenticated()) {
            BasicCredentialsProvider proxyCreds = new BasicCredentialsProvider();
            proxyCreds.setCredentials(new AuthScope(proxy.getHost(), proxy.getPort()), new UsernamePasswordCredentials(proxy.getUsername(), proxy.getPassword()));
            return proxyCreds;
        }
        return null;
    }

    protected <T> HttpResponse<T> transformBody(Function<RawResponse, HttpResponse<T>> transformer, RawResponse rr) {
        try {
            return transformer.apply(rr);
        }
        catch (UnrecoverableException ue) {
            return new BasicResponse(rr, "", ue);
        }
        catch (RuntimeException e) {
            String originalBody = this.recoverBody(rr);
            return new BasicResponse(rr, originalBody, e);
        }
    }

    private String recoverBody(RawResponse rr) {
        try {
            return rr.getContentAsString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setConfigFactory(RequestConfigFactory configFactory) {
        this.configFactory = configFactory;
    }

    protected static HttpHost determineTarget(HttpUriRequest request, Headers headers) {
        HttpHost target = null;
        URI requestURI = request.getURI();
        if (requestURI.isAbsolute()) {
            target = URIUtils.extractHost(requestURI);
            if (target == null) {
                throw new UnirestException("URI does not specify a valid host name: " + requestURI);
            }
            if (headers.containsKey("Host") && InetAddressUtils.isIPv4Address(target.getHostName())) {
                try {
                    InetAddress address = InetAddress.getByName(target.getHostName());
                    target = new HttpHost(address, headers.getFirst("Host"), target.getPort(), target.getSchemeName());
                }
                catch (UnknownHostException e) {
                    throw new UnirestException(e);
                }
            }
        }
        return target;
    }
}

