/*
 * Decompiled with CFR 0.152.
 */
package net.dartnode.mon;

import io.airbrake.javabrake.Notifier;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import kong.unirest.Unirest;
import net.dartnode.mon.DartNodeCore;
import net.dartnode.mon.VMStatsCollector;
import net.dartnode.mon.entites.task.HiveTask;
import net.dartnode.mon.entites.util.cli.CliUtil;
import net.dartnode.mon.service.RedisService;
import net.dartnode.mon.service.TaskService;

public class Main {
    public static DartNodeCore dn;
    public static String nodeId;
    public static float version;
    public static Notifier notifier;

    public static void main(String[] args2) {
        try {
            CliUtil.exec("mkdir -p /var/log/dartnode");
            File log = new File("/var/log/dartnode/current.log");
            try {
                Files.createFile(log.toPath(), new FileAttribute[0]);
            }
            catch (Exception e) {
                System.err.println("Failed to make the log file: " + e.getMessage());
            }
            PrintStream printStream = new PrintStream(Files.newOutputStream(log.toPath(), StandardOpenOption.APPEND, StandardOpenOption.WRITE));
            System.setOut(printStream);
            System.setErr(printStream);
            System.out.println("DartNode Logging Started.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        dn = new DartNodeCore("config.json");
        try {
            File file = new File("/tmp/dartnode.pid");
            if (file.exists()) {
                System.err.println("DartNode is already started somewhere else... Shutting Down.");
                System.exit(0);
            } else {
                String pidString = ManagementFactory.getRuntimeMXBean().getName();
                String pid = pidString.split("@")[0];
                FileWriter writer = new FileWriter(file.getPath());
                writer.write(pid);
                writer.close();
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    File file2 = new File("/tmp/dartnode.pid");
                    if (file2.exists()) {
                        file2.delete();
                    }
                }));
                if (!file.exists()) {
                    throw new IOException("Failed to make DartNode PID file :(");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String release = null;
        try {
            release = CliUtil.exec("md5sum /usr/local/dartnode/dartnode.jar | awk '{print $1}'");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String hostname = nodeId = dn.getConfigFile().getConfig().get("node").getAsString();
        try {
            hostname = CliUtil.exec("hostname");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println("Release: " + release);
        DartNodeCore.get(RedisService.class).getRedisConnection().sync().hset("dn_release", hostname, release);
        System.out.println("Version: " + version);
        System.out.println("Starting VM Stats Gather...");
        VMStatsCollector.init();
        System.out.println("Starting VM Pool...");
        DartNodeCore.get(TaskService.class).scheduleRepeatingTask(new HiveTask(){

            @Override
            public void run() {
                try {
                    System.out.println("Checking For Update...");
                    Main.checkForUpdate();
                    System.out.println("Rebuilding VM Pool...");
                    VMStatsCollector.buildPool();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }, 15000L, 15000L);
    }

    public static void checkForUpdate() {
        String remoteRev = Unirest.get("https://pkg.dev.snaju.com/dn/release.txt?ts=" + System.currentTimeMillis()).asString().getBody();
        String localRev = null;
        try {
            localRev = CliUtil.exec("md5sum /usr/local/dartnode/dartnode.jar | awk '{print $1}'");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!remoteRev.equalsIgnoreCase(localRev)) {
            try {
                System.out.println("Found New Update... Updating Now.");
                CliUtil.exec("bash /usr/local/dartnode/dartnode.sh update");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        nodeId = null;
        version = 1.1f;
    }
}

