/*
 * Decompiled with CFR 0.152.
 */
package net.dartnode.mon.entites.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import net.dartnode.mon.entites.util.GsonUtil;

public class HiveConfigFile {
    private File file;
    private JsonObject config;

    public HiveConfigFile(File file) {
        this.file = file;
        this.config = new JsonObject();
    }

    public JsonObject getConfig() {
        return this.config;
    }

    public void load() throws IOException {
        if (Files.exists(this.file.toPath(), new LinkOption[0])) {
            byte[] data = Files.readAllBytes(this.file.toPath());
            this.config = JsonParser.parseString(new String(data, StandardCharsets.UTF_8)).getAsJsonObject();
        } else {
            this.generate();
        }
    }

    public void save() throws IOException {
        if (!Files.exists(this.file.toPath(), new LinkOption[0])) {
            this.generate();
        }
        Gson g2 = new GsonBuilder().setPrettyPrinting().create();
        Files.write(this.file.toPath(), g2.toJson(this.config).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public void generate() throws IOException {
        if (!Files.exists(this.file.toPath(), new LinkOption[0])) {
            Files.createFile(this.file.toPath(), new FileAttribute[0]);
        }
    }

    public void merge(JsonElement e) {
        this.config = GsonUtil.merge(this.config, e).getAsJsonObject();
    }
}

