/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.publisher.SourceProducer;
import reactor.util.annotation.Nullable;

final class FluxConcatArray<T>
extends Flux<T>
implements SourceProducer<T> {
    final Publisher<? extends T>[] array;
    final boolean delayError;

    @SafeVarargs
    FluxConcatArray(boolean delayError, Publisher<? extends T> ... array) {
        this.array = Objects.requireNonNull(array, "array");
        this.delayError = delayError;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Publisher<? extends T>[] a = this.array;
        if (a.length == 0) {
            Operators.complete(actual);
            return;
        }
        if (a.length == 1) {
            Publisher<T> p = a[0];
            if (p == null) {
                Operators.error(actual, new NullPointerException("The single source Publisher is null"));
            } else {
                p.subscribe(actual);
            }
            return;
        }
        if (this.delayError) {
            ConcatArrayDelayErrorSubscriber<T> parent = new ConcatArrayDelayErrorSubscriber<T>(actual, a);
            actual.onSubscribe(parent);
            if (!parent.isCancelled()) {
                parent.onComplete();
            }
            return;
        }
        ConcatArraySubscriber<T> parent = new ConcatArraySubscriber<T>(actual, a);
        actual.onSubscribe(parent);
        if (!parent.isCancelled()) {
            parent.onComplete();
        }
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.DELAY_ERROR) {
            return this.delayError;
        }
        return null;
    }

    FluxConcatArray<T> concatAdditionalSourceLast(Publisher<? extends T> source2) {
        int n = this.array.length;
        Publisher[] newArray = new Publisher[n + 1];
        System.arraycopy(this.array, 0, newArray, 0, n);
        newArray[n] = source2;
        return new FluxConcatArray<T>(this.delayError, newArray);
    }

    <V> FluxConcatArray<V> concatAdditionalIgnoredLast(Publisher<? extends V> source2) {
        int n = this.array.length;
        Publisher[] newArray = new Publisher[n + 1];
        System.arraycopy(this.array, 0, newArray, 0, n);
        newArray[n - 1] = Mono.ignoreElements(newArray[n - 1]);
        newArray[n] = source2;
        return new FluxConcatArray<T>(this.delayError, newArray);
    }

    FluxConcatArray<T> concatAdditionalSourceFirst(Publisher<? extends T> source2) {
        int n = this.array.length;
        Publisher[] newArray = new Publisher[n + 1];
        System.arraycopy(this.array, 0, newArray, 1, n);
        newArray[0] = source2;
        return new FluxConcatArray<T>(this.delayError, newArray);
    }

    static final class ConcatArrayDelayErrorSubscriber<T>
    extends Operators.MultiSubscriptionSubscriber<T, T> {
        final Publisher<? extends T>[] sources;
        int index;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<ConcatArrayDelayErrorSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(ConcatArrayDelayErrorSubscriber.class, "wip");
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<ConcatArrayDelayErrorSubscriber, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(ConcatArrayDelayErrorSubscriber.class, Throwable.class, "error");
        long produced;

        ConcatArrayDelayErrorSubscriber(CoreSubscriber<? super T> actual, Publisher<? extends T>[] sources) {
            super(actual);
            this.sources = sources;
        }

        @Override
        public void onNext(T t) {
            ++this.produced;
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            if (Exceptions.addThrowable(ERROR, this, t)) {
                this.onComplete();
            } else {
                Operators.onErrorDropped(t, this.actual.currentContext());
            }
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.DELAY_ERROR) {
                return true;
            }
            if (key == Scannable.Attr.ERROR) {
                return this.error;
            }
            return super.scanUnsafe(key);
        }

        @Override
        public void onComplete() {
            if (WIP.getAndIncrement(this) == 0) {
                Publisher<? extends T>[] a = this.sources;
                do {
                    if (this.isCancelled()) {
                        return;
                    }
                    int i = this.index;
                    if (i == a.length) {
                        Throwable e = Exceptions.terminate(ERROR, this);
                        if (e != null) {
                            this.actual.onError(e);
                        } else {
                            this.actual.onComplete();
                        }
                        return;
                    }
                    Publisher<T> p = a[i];
                    if (p == null) {
                        this.actual.onError(new NullPointerException("Source Publisher at index " + i + " is null"));
                        return;
                    }
                    long c = this.produced;
                    if (c != 0L) {
                        this.produced = 0L;
                        this.produced(c);
                    }
                    p.subscribe(this);
                    if (this.isCancelled()) {
                        return;
                    }
                    this.index = ++i;
                } while (WIP.decrementAndGet(this) != 0);
            }
        }
    }

    static final class ConcatArraySubscriber<T>
    extends Operators.MultiSubscriptionSubscriber<T, T> {
        final Publisher<? extends T>[] sources;
        int index;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<ConcatArraySubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(ConcatArraySubscriber.class, "wip");
        long produced;

        ConcatArraySubscriber(CoreSubscriber<? super T> actual, Publisher<? extends T>[] sources) {
            super(actual);
            this.sources = sources;
        }

        @Override
        public void onNext(T t) {
            ++this.produced;
            this.actual.onNext(t);
        }

        @Override
        public void onComplete() {
            if (WIP.getAndIncrement(this) == 0) {
                Publisher<? extends T>[] a = this.sources;
                do {
                    if (this.isCancelled()) {
                        return;
                    }
                    int i = this.index;
                    if (i == a.length) {
                        this.actual.onComplete();
                        return;
                    }
                    Publisher<T> p = a[i];
                    if (p == null) {
                        this.actual.onError(new NullPointerException("Source Publisher at index " + i + " is null"));
                        return;
                    }
                    long c = this.produced;
                    if (c != 0L) {
                        this.produced = 0L;
                        this.produced(c);
                    }
                    p.subscribe(this);
                    if (this.isCancelled()) {
                        return;
                    }
                    this.index = ++i;
                } while (WIP.decrementAndGet(this) != 0);
            }
        }
    }
}

