/*
 * Decompiled with CFR 0.152.
 */
package fr.devnied.bitlib;

import fr.devnied.bitlib.BytesUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BitUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BitUtils.class.getName());
    public static final int BYTE_SIZE = 8;
    public static final float BYTE_SIZE_F = 8.0f;
    private static final int DEFAULT_VALUE = 255;
    private static final Charset DEFAULT_CHARSET = Charset.forName("ASCII");
    public static final String DATE_FORMAT = "yyyyMMdd";
    private final byte[] byteTab;
    private int currentBitIndex;
    private final int size;

    public BitUtils(byte[] pByte) {
        this.byteTab = new byte[pByte.length];
        System.arraycopy(pByte, 0, this.byteTab, 0, pByte.length);
        this.size = pByte.length * 8;
    }

    public BitUtils(int pSize) {
        this.byteTab = new byte[(int)Math.ceil((float)pSize / 8.0f)];
        this.size = pSize;
    }

    public void addCurrentBitIndex(int pIndex) {
        this.currentBitIndex += pIndex;
        if (this.currentBitIndex < 0) {
            this.currentBitIndex = 0;
        }
    }

    public int getCurrentBitIndex() {
        return this.currentBitIndex;
    }

    public byte[] getData() {
        byte[] ret = new byte[this.byteTab.length];
        System.arraycopy(this.byteTab, 0, ret, 0, this.byteTab.length);
        return ret;
    }

    public byte getMask(int pIndex, int pLength) {
        byte ret = -1;
        ret = (byte)(ret << pIndex);
        ret = (byte)((ret & 0xFF) >> pIndex);
        int dec = 8 - (pLength + pIndex);
        if (dec > 0) {
            ret = (byte)(ret >> dec);
            ret = (byte)(ret << dec);
        }
        return ret;
    }

    public boolean getNextBoolean() {
        boolean ret = false;
        if (this.getNextInteger(1) == 1) {
            ret = true;
        }
        return ret;
    }

    public byte[] getNextByte(int pSize) {
        return this.getNextByte(pSize, true);
    }

    public byte[] getNextByte(int pSize, boolean pShift) {
        byte[] tab = new byte[(int)Math.ceil((float)pSize / 8.0f)];
        if (this.currentBitIndex % 8 != 0) {
            int index = 0;
            int max = this.currentBitIndex + pSize;
            while (this.currentBitIndex < max) {
                int mod = this.currentBitIndex % 8;
                int modTab = index % 8;
                int length = Math.min(max - this.currentBitIndex, Math.min(8 - mod, 8 - modTab));
                byte val = (byte)(this.byteTab[this.currentBitIndex / 8] & this.getMask(mod, length));
                if (pShift || pSize % 8 == 0) {
                    val = mod != 0 ? (byte)(val << Math.min(mod, 8 - length)) : (byte)((val & 0xFF) >> modTab);
                }
                int n = index / 8;
                tab[n] = (byte)(tab[n] | val);
                this.currentBitIndex += length;
                index += length;
            }
            if (!pShift && pSize % 8 != 0) {
                tab[tab.length - 1] = (byte)(tab[tab.length - 1] & this.getMask((max - pSize - 1) % 8, 8));
            }
        } else {
            System.arraycopy(this.byteTab, this.currentBitIndex / 8, tab, 0, tab.length);
            int val = pSize % 8;
            if (val == 0) {
                val = 8;
            }
            tab[tab.length - 1] = (byte)(tab[tab.length - 1] & this.getMask(this.currentBitIndex % 8, val));
            this.currentBitIndex += pSize;
        }
        return tab;
    }

    public Date getNextDate(int pSize, String pPattern) {
        return this.getNextDate(pSize, pPattern, false);
    }

    public Date getNextDate(int pSize, String pPattern, boolean pUseBcd) {
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat(pPattern);
        String dateTxt = null;
        dateTxt = pUseBcd ? this.getNextHexaString(pSize) : this.getNextString(pSize);
        try {
            date = sdf.parse(dateTxt);
        }
        catch (ParseException e) {
            LOGGER.error("Parsing date error. date:" + dateTxt + " pattern:" + pPattern, (Throwable)e);
        }
        return date;
    }

    public String getNextHexaString(int pSize) {
        return BytesUtils.bytesToStringNoSpace(this.getNextByte(pSize, true));
    }

    public long getNextLongSigned(int pLength) {
        long signMask;
        if (pLength > 64) {
            throw new IllegalArgumentException("Long overflow with length > 64");
        }
        long decimal = this.getNextLong(pLength);
        if ((decimal & (signMask = (long)(1 << pLength - 1))) != 0L) {
            return -(signMask - (signMask ^ decimal));
        }
        return decimal;
    }

    public int getNextIntegerSigned(int pLength) {
        if (pLength > 32) {
            throw new IllegalArgumentException("Integer overflow with length > 32");
        }
        return (int)this.getNextLongSigned(pLength);
    }

    public long getNextLong(int pLength) {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        long finalValue = 0L;
        long currentValue = 0L;
        int readSize = pLength;
        int max = this.currentBitIndex + pLength;
        while (this.currentBitIndex < max) {
            int mod = this.currentBitIndex % 8;
            currentValue = this.byteTab[this.currentBitIndex / 8] & this.getMask(mod, readSize) & 0xFF;
            int dec = Math.max(8 - (mod + readSize), 0);
            currentValue = (currentValue & 0xFFL) >>> dec & 0xFFL;
            finalValue = finalValue << Math.min(readSize, 8) | currentValue;
            int val = 8 - mod;
            readSize -= val;
            this.currentBitIndex = Math.min(this.currentBitIndex + val, max);
        }
        buffer.putLong(finalValue);
        ((Buffer)buffer).rewind();
        return buffer.getLong();
    }

    public int getNextInteger(int pLength) {
        return (int)this.getNextLong(pLength);
    }

    public String getNextString(int pSize) {
        return this.getNextString(pSize, DEFAULT_CHARSET);
    }

    public String getNextString(int pSize, Charset pCharset) {
        return new String(this.getNextByte(pSize, true), pCharset);
    }

    public int getSize() {
        return this.size;
    }

    public void reset() {
        this.setCurrentBitIndex(0);
    }

    public void clear() {
        Arrays.fill(this.byteTab, (byte)0);
        this.reset();
    }

    public void resetNextBits(int pLength) {
        int max = this.currentBitIndex + pLength;
        while (this.currentBitIndex < max) {
            int mod = this.currentBitIndex % 8;
            int length = Math.min(max - this.currentBitIndex, 8 - mod);
            int n = this.currentBitIndex / 8;
            this.byteTab[n] = (byte)(this.byteTab[n] & ~this.getMask(mod, length));
            this.currentBitIndex += length;
        }
    }

    public void setCurrentBitIndex(int pCurrentBitIndex) {
        this.currentBitIndex = pCurrentBitIndex;
    }

    public void setNextBoolean(boolean pBoolean) {
        if (pBoolean) {
            this.setNextInteger(1, 1);
        } else {
            this.setNextInteger(0, 1);
        }
    }

    public void setNextByte(byte[] pValue, int pLength) {
        this.setNextByte(pValue, pLength, true);
    }

    public void setNextByte(byte[] pValue, int pLength, boolean pPadBefore) {
        int i;
        int totalSize = (int)Math.ceil((float)pLength / 8.0f);
        ByteBuffer buffer = ByteBuffer.allocate(totalSize);
        int size = Math.max(totalSize - pValue.length, 0);
        if (pPadBefore) {
            for (i = 0; i < size; ++i) {
                buffer.put((byte)0);
            }
        }
        buffer.put(pValue, 0, Math.min(totalSize, pValue.length));
        if (!pPadBefore) {
            for (i = 0; i < size; ++i) {
                buffer.put((byte)0);
            }
        }
        byte[] tab = buffer.array();
        if (this.currentBitIndex % 8 != 0) {
            int index = 0;
            int max = this.currentBitIndex + pLength;
            while (this.currentBitIndex < max) {
                int mod = this.currentBitIndex % 8;
                int modTab = index % 8;
                int length = Math.min(max - this.currentBitIndex, Math.min(8 - mod, 8 - modTab));
                byte val = (byte)(tab[index / 8] & this.getMask(modTab, length));
                val = mod == 0 ? (byte)(val << Math.min(modTab, 8 - length)) : (byte)((val & 0xFF) >> mod);
                int n = this.currentBitIndex / 8;
                this.byteTab[n] = (byte)(this.byteTab[n] | val);
                this.currentBitIndex += length;
                index += length;
            }
        } else {
            System.arraycopy(tab, 0, this.byteTab, this.currentBitIndex / 8, tab.length);
            this.currentBitIndex += pLength;
        }
    }

    public void setNextDate(Date pValue, String pPattern) {
        this.setNextDate(pValue, pPattern, false);
    }

    public void setNextDate(Date pValue, String pPattern, boolean pUseBcd) {
        SimpleDateFormat sdf = new SimpleDateFormat(pPattern);
        String value = sdf.format(pValue);
        if (pUseBcd) {
            this.setNextHexaString(value, value.length() * 4);
        } else {
            this.setNextString(value, value.length() * 8);
        }
    }

    public void setNextHexaString(String pValue, int pLength) {
        this.setNextByte(BytesUtils.fromString(pValue), pLength);
    }

    public void setNextLong(long pValue, int pLength) {
        if (pLength > 64) {
            throw new IllegalArgumentException("Long overflow with length > 64");
        }
        this.setNextValue(pValue, pLength, 63);
    }

    protected void setNextValue(long pValue, int pLength, int pMaxSize) {
        long value = pValue;
        long bitMax = (long)Math.pow(2.0, Math.min(pLength, pMaxSize));
        if (pValue > bitMax) {
            value = bitMax - 1L;
        }
        int writeSize = pLength;
        while (writeSize > 0) {
            int mod = this.currentBitIndex % 8;
            byte ret = 0;
            if (mod == 0 && writeSize <= 8 || pLength < 8 - mod) {
                ret = (byte)(value << 8 - (writeSize + mod));
            } else {
                long length = Long.toBinaryString(value).length();
                ret = (byte)(value >> (int)((long)writeSize - length - (8L - length - (long)mod)));
            }
            int n = this.currentBitIndex / 8;
            this.byteTab[n] = (byte)(this.byteTab[n] | ret);
            long val = Math.min(writeSize, 8 - mod);
            writeSize = (int)((long)writeSize - val);
            this.currentBitIndex = (int)((long)this.currentBitIndex + val);
        }
    }

    public void setNextInteger(int pValue, int pLength) {
        if (pLength > 32) {
            throw new IllegalArgumentException("Integer overflow with length > 32");
        }
        this.setNextValue(pValue, pLength, 31);
    }

    public void setNextString(String pValue, int pLength) {
        this.setNextString(pValue, pLength, true);
    }

    public void setNextString(String pValue, int pLength, boolean pPaddedBefore) {
        this.setNextByte(pValue.getBytes(Charset.defaultCharset()), pLength, pPaddedBefore);
    }
}

