/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jrxtx;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.RXTXPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.openmuc.jrxtx.DataBits;
import org.openmuc.jrxtx.FlowControl;
import org.openmuc.jrxtx.Parity;
import org.openmuc.jrxtx.PortNotFoundException;
import org.openmuc.jrxtx.SerialPort;
import org.openmuc.jrxtx.SerialPortException;
import org.openmuc.jrxtx.SerialPortTimeoutException;
import org.openmuc.jrxtx.StopBits;

class JRxTxPort
implements SerialPort {
    private volatile boolean closed;
    private RXTXPort rxtxPort;
    private SerialInputStream serialIs;
    private SerialOutputStream serial0s;
    private String portName;
    private DataBits dataBits;
    private Parity parity;
    private StopBits stopBits;
    private int baudRate;
    private int serialPortTimeout;
    private FlowControl flowControl;

    public static JRxTxPort openSerialPort(String portName, int baudRate, Parity parity, DataBits dataBits, StopBits stopBits, FlowControl flowControl) throws SerialPortException {
        try {
            System.setProperty("gnu.io.rxtx.SerialPorts", portName);
            CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier(portName);
            String theOwner = JRxTxPort.class.getCanonicalName() + System.currentTimeMillis();
            CommPort comPort = portIdentifier.open(theOwner, 0);
            if (!(comPort instanceof RXTXPort)) {
                throw new SerialPortException("Unable to open the serial port. Port is not RXTX.");
            }
            RXTXPort rxtxPort = (RXTXPort)comPort;
            try {
                rxtxPort.setSerialPortParams(baudRate, dataBits.getOldValue(), stopBits.getOldValue(), parity.getOldValue());
                JRxTxPort.setFlowControl(flowControl, rxtxPort);
            }
            catch (UnsupportedCommOperationException e) {
                String message = MessageFormat.format("Unable to apply config on serial port.\n{0}", e.getMessage());
                throw new SerialPortException(message);
            }
            return new JRxTxPort(rxtxPort, portName, baudRate, parity, dataBits, stopBits, flowControl);
        }
        catch (NoSuchPortException e) {
            String errMessage = MessageFormat.format("Serial port {0} not found or port is busy.", portName);
            throw new PortNotFoundException(errMessage);
        }
        catch (PortInUseException e) {
            String errMessage = MessageFormat.format("Serial port {0} is already in use.", portName);
            throw new PortNotFoundException(errMessage);
        }
    }

    private static void setFlowControl(FlowControl flowControl, RXTXPort rxtxPort) {
        switch (flowControl) {
            case RTS_CTS: {
                rxtxPort.setFlowControlMode(3);
                break;
            }
            case XON_XOFF: {
                rxtxPort.setFlowControlMode(12);
                break;
            }
            default: {
                rxtxPort.setFlowControlMode(0);
            }
        }
    }

    private JRxTxPort(RXTXPort comPort, String portName, int baudRate, Parity parity, DataBits dataBits, StopBits stopBits, FlowControl flowControl) {
        this.rxtxPort = comPort;
        this.portName = portName;
        this.baudRate = baudRate;
        this.parity = parity;
        this.dataBits = dataBits;
        this.stopBits = stopBits;
        this.flowControl = flowControl;
        this.closed = false;
        this.serial0s = new SerialOutputStream(this.rxtxPort.getOutputStream());
        this.serialIs = new SerialInputStream();
    }

    public InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SerialPortException("Serial port is closed");
        }
        return this.serialIs;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SerialPortException("Serial port is closed");
        }
        return this.serial0s;
    }

    public synchronized void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.serial0s.closeStream();
            this.serialIs.closeStream();
            this.rxtxPort.close();
            this.serial0s = null;
            this.serialIs = null;
            this.rxtxPort = null;
        }
        finally {
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String getPortName() {
        return this.portName;
    }

    public DataBits getDataBits() {
        return this.dataBits;
    }

    public void setDataBits(DataBits dataBits) throws IOException {
        this.dataBits = dataBits;
        this.updateWrappedPort();
    }

    public Parity getParity() {
        return this.parity;
    }

    public void setParity(Parity parity) throws IOException {
        this.parity = parity;
        this.updateWrappedPort();
    }

    public StopBits getStopBits() {
        return this.stopBits;
    }

    public void setStopBits(StopBits stopBits) throws IOException {
        this.stopBits = stopBits;
        this.updateWrappedPort();
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public void setBaudRate(int baudRate) throws IOException {
        this.baudRate = baudRate;
        this.updateWrappedPort();
    }

    private void updateWrappedPort() throws IOException {
        try {
            this.rxtxPort.setSerialPortParams(this.baudRate, this.dataBits.getOldValue(), this.stopBits.getOldValue(), this.parity.getOldValue());
        }
        catch (UnsupportedCommOperationException e) {
            throw new IOException(e.getMessage());
        }
    }

    public int getSerialPortTimeout() {
        return this.serialPortTimeout;
    }

    public void setSerialPortTimeout(int serialPortTimeout) throws IOException {
        this.serialPortTimeout = serialPortTimeout;
    }

    public void setFlowControl(FlowControl flowControl) throws IOException {
        JRxTxPort.setFlowControl(flowControl, this.rxtxPort);
        this.flowControl = flowControl;
    }

    public FlowControl getFlowControl() {
        return this.flowControl;
    }

    private class SerialOutputStream
    extends OutputStream {
        private OutputStream serialOutputStream;

        public SerialOutputStream(OutputStream serialOutputStream) {
            this.serialOutputStream = serialOutputStream;
        }

        public void write(int b) throws IOException {
            this.checkIfOpen();
            this.serialOutputStream.write(b);
        }

        private void checkIfOpen() throws SerialPortException {
            if (JRxTxPort.this.isClosed()) {
                throw new SerialPortException("Port has been closed.");
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.checkIfOpen();
            this.serialOutputStream.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            this.checkIfOpen();
            this.serialOutputStream.write(b);
        }

        public void flush() throws IOException {
            this.checkIfOpen();
            this.serialOutputStream.flush();
        }

        private void closeStream() throws IOException {
            this.serialOutputStream.close();
        }

        public void close() throws IOException {
            JRxTxPort.this.close();
        }
    }

    private class SerialInputStream
    extends InputStream {
        private static final long SLEEP_TIME = 10L;

        private SerialInputStream() {
        }

        public synchronized int read() throws IOException {
            long elapsedTime = 0L;
            InputStream serialInputStream = JRxTxPort.this.rxtxPort.getInputStream();
            do {
                if (serialInputStream.available() > 0) {
                    return serialInputStream.read();
                }
                try {
                    Thread.sleep(10L);
                    elapsedTime += 10L;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!JRxTxPort.this.isClosed()) continue;
                throw new SerialPortException("Serial port has been closed.");
            } while (JRxTxPort.this.getSerialPortTimeout() == 0 || elapsedTime <= (long)JRxTxPort.this.getSerialPortTimeout());
            throw new SerialPortTimeoutException();
        }

        public int available() throws IOException {
            return JRxTxPort.this.rxtxPort.getInputStream().available();
        }

        private void closeStream() throws IOException {
            JRxTxPort.this.rxtxPort.getInputStream().close();
        }

        public void close() throws IOException {
            JRxTxPort.this.close();
        }
    }
}

