/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.http;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Consumer;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import lowentry.ue4.classes.http.HttpClient;
import lowentry.ue4.classes.http.HttpRequest;
import lowentry.ue4.classes.http.HttpResponse;
import lowentry.ue4.classes.http.HttpServerListener;
import lowentry.ue4.classes.internal.CachedTime;
import lowentry.ue4.libs.pyronet.craterstudio.util.concur.SimpleBlockingQueue;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroException;

public class HttpServer
implements Iterable<HttpClient> {
    private static final int NEW_CONNECTIONS_QUEUE_SIZE = 500;
    protected static final ThreadLocal<SimpleDateFormat> serverTimeFormat = HttpServer.createServerTimeFormat();
    protected final Thread networkThread;
    protected final boolean secure;
    protected final int port;
    protected final HttpServerListener listener;
    protected final ServerSocket server;
    protected final Collection<HttpClient> clients = new ArrayList<HttpClient>();
    protected final Collection<HttpClient> removeClients = new ArrayList<HttpClient>();
    protected final ByteBuffer networkBuffer = ByteBuffer.allocate(524288);
    protected volatile boolean run = true;
    protected final SimpleBlockingQueue<Runnable> tasks = new SimpleBlockingQueue();

    public HttpServer(boolean secure, boolean acceptExternalConnections, int port, HttpServerListener listener) throws Exception {
        this.networkThread = Thread.currentThread();
        this.secure = secure;
        this.port = port;
        this.listener = listener;
        this.server = this.initialize(secure, acceptExternalConnections, port);
    }

    protected static ThreadLocal<SimpleDateFormat> createServerTimeFormat() {
        return ThreadLocal.withInitial(() -> {
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            return dateFormat;
        });
    }

    protected ServerSocket initialize(boolean secure, boolean acceptExternalConnections, int port) throws Exception {
        ServerSocketFactory serverSocketFactory = secure ? SSLServerSocketFactory.getDefault() : ServerSocketFactory.getDefault();
        ServerSocket server = serverSocketFactory.createServerSocket(port, 500, acceptExternalConnections ? null : InetAddress.getLoopbackAddress());
        if (secure && server instanceof SSLServerSocket) {
            SSLServerSocket serverssl = (SSLServerSocket)server;
            serverssl.setEnabledCipherSuites(serverssl.getSupportedCipherSuites());
            serverssl.setEnabledProtocols(serverssl.getSupportedProtocols());
        }
        server.setSoTimeout(100);
        return server;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public final boolean isNetworkThread() {
        return this.networkThread == Thread.currentThread();
    }

    public final Thread networkThread() {
        return this.networkThread;
    }

    public final void checkThread() {
        if (!this.isNetworkThread()) {
            throw new PyroException("call from outside the network-thread, you must schedule tasks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listen() {
        Iterator iterator;
        this.checkThread();
        this.executePendingTasks();
        if (this.run) {
            ArrayList<HttpClient> removeClientsArray = null;
            iterator = this.removeClients;
            synchronized (iterator) {
                if (this.removeClients.size() > 0) {
                    removeClientsArray = new ArrayList<HttpClient>(this.removeClients);
                    this.removeClients.clear();
                }
            }
            if (removeClientsArray != null) {
                iterator = this.clients;
                synchronized (iterator) {
                    this.clients.removeAll(removeClientsArray);
                }
                for (HttpClient httpClient : removeClientsArray) {
                    this.internal_listenerClientDisconnected(httpClient);
                }
            }
            long time = CachedTime.millisSinceStart();
            for (HttpClient client : this.clients) {
                try {
                    client.listen(time);
                }
                catch (Exception e) {
                    client.disconnect();
                }
            }
            removeClientsArray = null;
            iterator = this.removeClients;
            synchronized (iterator) {
                if (this.removeClients.size() > 0) {
                    removeClientsArray = new ArrayList<HttpClient>(this.removeClients);
                    this.removeClients.clear();
                }
            }
            if (removeClientsArray != null) {
                iterator = this.clients;
                synchronized (iterator) {
                    this.clients.removeAll(removeClientsArray);
                }
                for (HttpClient httpClient : removeClientsArray) {
                    this.internal_listenerClientDisconnected(httpClient);
                }
            }
            try {
                Socket s = this.server.accept();
                try {
                    HttpClient client2 = new HttpClient(this, s);
                    this.internal_listenerClientConnected(client2);
                    Collection<HttpClient> collection = this.clients;
                    synchronized (collection) {
                        this.clients.add(client2);
                    }
                }
                catch (Exception e) {
                    s.close();
                }
            }
            catch (Exception s) {
                // empty catch block
            }
        }
        if (!this.run && !this.server.isClosed()) {
            ArrayList<HttpClient> removeClientsArray;
            iterator = this.removeClients;
            synchronized (iterator) {
                removeClientsArray = new ArrayList<HttpClient>(this.removeClients);
                this.removeClients.clear();
            }
            iterator = this.clients;
            synchronized (iterator) {
                this.clients.removeAll(removeClientsArray);
            }
            for (HttpClient httpClient : removeClientsArray) {
                this.internal_listenerClientDisconnected(httpClient);
            }
            iterator = this.clients;
            synchronized (iterator) {
                removeClientsArray = new ArrayList<HttpClient>(this.clients);
                this.clients.clear();
            }
            for (HttpClient httpClient : removeClientsArray) {
                httpClient.internal_disconnect();
            }
            for (HttpClient httpClient : removeClientsArray) {
                this.internal_listenerClientDisconnected(httpClient);
            }
            try {
                this.server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.executePendingTasks();
    }

    protected void executePendingTasks() {
        Runnable task;
        while ((task = this.tasks.poll()) != null) {
            try {
                task.run();
            }
            catch (Exception cause) {
                cause.printStackTrace();
            }
        }
    }

    protected static String internal_getServerTime() {
        return serverTimeFormat.get().format(Calendar.getInstance().getTime());
    }

    protected void internal_listenerClientConnected(HttpClient client) {
        this.listener.clientConnected(this, client);
    }

    protected void internal_listenerClientDisconnected(HttpClient client) {
        this.listener.clientDisconnected(this, client);
    }

    protected void internal_listenerReceivedRequest(HttpClient client, HttpRequest request, HttpResponse response) {
        this.listener.receivedRequest(this, client, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internal_removeClient(HttpClient client) {
        Collection<HttpClient> collection = this.removeClients;
        synchronized (collection) {
            this.removeClients.add(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<HttpClient> iterator() {
        ArrayList<HttpClient> copy;
        Collection<HttpClient> collection = this.clients;
        synchronized (collection) {
            copy = new ArrayList<HttpClient>(this.clients);
        }
        return copy.iterator();
    }

    public void forEachClient(Consumer<HttpClient> action) {
        this.forEach(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientCount() {
        Collection<HttpClient> collection = this.clients;
        synchronized (collection) {
            return this.clients.size();
        }
    }

    public void terminate() {
        this.run = false;
    }

    public void execute(Runnable runnable) {
        if (this.isNetworkThread()) {
            runnable.run();
        } else {
            this.tasks.put(runnable);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.server.getClass().getName() + "[/" + this.server.getInetAddress().getHostAddress() + ":" + this.server.getLocalPort() + "]]";
    }
}

