/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.http;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import lowentry.ue4.classes.http.HttpClient;
import lowentry.ue4.classes.http.HttpRequest;
import lowentry.ue4.classes.http.HttpResponse;
import lowentry.ue4.classes.http.HttpServer;
import lowentry.ue4.classes.http.HttpServerListener;
import lowentry.ue4.classes.http.HttpTasks;
import lowentry.ue4.classes.http.ThreadedHttpServerListener;
import lowentry.ue4.classes.utility.ThreadSleeper;
import lowentry.ue4.libs.pyronet.craterstudio.util.concur.SimpleBlockingQueue;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroException;

public class ThreadedHttpServer
implements Iterable<HttpClient> {
    protected static final Iterator<HttpClient> nullIterator;
    private static int ID;
    private static final Object idSynchronizer;
    protected final ThreadSleeper startSleeper = new ThreadSleeper();
    protected final Thread networkThread;
    protected final boolean secure;
    protected final boolean acceptExternalConnections;
    protected final int port;
    protected final ThreadedHttpServerListener listener;
    protected volatile HttpServer server;
    protected final SimpleBlockingQueue<Runnable> tasks = new SimpleBlockingQueue();
    protected volatile Exception startException = null;
    protected volatile boolean started = false;

    public ThreadedHttpServer(boolean secure, boolean acceptExternalConnections, int port, ThreadedHttpServerListener listener) throws Exception {
        this.networkThread = Thread.currentThread();
        this.secure = secure;
        this.listener = listener;
        this.acceptExternalConnections = acceptExternalConnections;
        this.port = port;
        this.start();
    }

    public ThreadedHttpServer(boolean secure, boolean acceptExternalConnections, int port, HttpServerListener listener) throws Exception {
        this.networkThread = Thread.currentThread();
        this.secure = secure;
        this.listener = ThreadedHttpServer.getWrappedListener(listener);
        this.acceptExternalConnections = acceptExternalConnections;
        this.port = port;
        this.start();
    }

    public static ThreadedHttpServerListener getWrappedListener(final HttpServerListener listener) {
        return new ThreadedHttpServerListener(){

            @Override
            public void clientConnected(ThreadedHttpServer threadedServer, HttpServer server, HttpClient client) {
                listener.clientConnected(server, client);
            }

            @Override
            public void clientDisconnected(ThreadedHttpServer threadedServer, HttpServer server, HttpClient client) {
                listener.clientDisconnected(server, client);
            }

            @Override
            public void receivedRequest(ThreadedHttpServer threadedServer, HttpServer server, HttpClient client, HttpRequest request, HttpResponse response) {
                listener.receivedRequest(server, client, request, response);
            }
        };
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    protected void start() throws Exception {
        Thread thread = new Thread(() -> {
            HttpServerListener list = new HttpServerListener(){

                @Override
                public void clientConnected(HttpServer server, HttpClient client) {
                    ThreadedHttpServer.this.tasks.put(new HttpTasks.ClientConnectedThreadedHttpServer(ThreadedHttpServer.this, ThreadedHttpServer.this.listener, server, client));
                }

                @Override
                public void clientDisconnected(HttpServer server, HttpClient client) {
                    ThreadedHttpServer.this.tasks.put(new HttpTasks.ClientDisconnectedThreadedHttpServer(ThreadedHttpServer.this, ThreadedHttpServer.this.listener, server, client));
                }

                @Override
                public void receivedRequest(HttpServer server, HttpClient client, HttpRequest request, HttpResponse response) {
                    ThreadedHttpServer.this.tasks.put(new HttpTasks.ReceivedRequestThreadedHttpServer(ThreadedHttpServer.this, ThreadedHttpServer.this.listener, server, client, request, response));
                }
            };
            Exception exception = null;
            try {
                this.server = new HttpServer(this.secure, this.acceptExternalConnections, this.port, list);
            }
            catch (Exception e) {
                exception = e;
                this.startException = e;
            }
            this.started = true;
            this.startSleeper.wakeup();
            if (exception != null) {
                return;
            }
            while (this.server.run) {
                this.server.listen();
            }
        }, "Threaded-Http-Server-" + ThreadedHttpServer.getNextId());
        thread.setDaemon(true);
        thread.start();
        this.waitTillStarted();
        if (this.startException != null) {
            throw new Exception(this.startException);
        }
    }

    protected void waitTillStarted() {
        while (!this.started) {
            this.startSleeper.sleep(50L);
        }
    }

    @Override
    public Iterator<HttpClient> iterator() {
        HttpServer finalServer = this.server;
        if (finalServer != null) {
            return finalServer.iterator();
        }
        return nullIterator;
    }

    public void forEachClient(Consumer<HttpClient> action) {
        HttpServer finalServer = this.server;
        if (finalServer != null) {
            finalServer.forEach(action);
        }
    }

    public int getClientCount() {
        HttpServer finalServer = this.server;
        if (finalServer != null) {
            return finalServer.getClientCount();
        }
        return 0;
    }

    public void terminate() {
        HttpServer finalServer = this.server;
        if (finalServer != null) {
            finalServer.terminate();
        }
    }

    public void executePendingTasks() {
        Runnable task;
        if (this.networkThread != Thread.currentThread()) {
            throw new PyroException("call from outside the network-thread");
        }
        while ((task = this.tasks.poll()) != null) {
            try {
                task.run();
            }
            catch (Exception cause) {
                cause.printStackTrace();
            }
        }
    }

    public void addTask(Runnable task) {
        if (task != null) {
            this.tasks.put(task);
        }
    }

    public void execute(Runnable runnable) {
        if (this.networkThread == Thread.currentThread()) {
            runnable.run();
        } else {
            this.tasks.put(runnable);
        }
    }

    public HttpServer server() {
        return this.server;
    }

    public String toString() {
        HttpServer finalServer = this.server;
        if (finalServer != null) {
            return finalServer.toString();
        }
        return super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getNextId() {
        Object object = idSynchronizer;
        synchronized (object) {
            int id = ID++;
            if (ID >= Integer.MAX_VALUE) {
                ID = 1;
            }
            return id;
        }
    }

    static {
        ID = 1;
        idSynchronizer = new Object();
        nullIterator = new Iterator<HttpClient>(){

            @Override
            public HttpClient next() {
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return false;
            }
        };
    }
}

