/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.internal;

public class HashingPearson {
    private static final byte[] pearson = new byte[]{98, 6, 85, -106, 36, 23, 112, -92, -121, -49, -87, 5, 26, 64, -91, -37, 61, 20, 68, 89, -126, 63, 52, 102, 24, -27, -124, -11, 80, -40, -61, 115, 90, -88, -100, -53, -79, 120, 2, -66, -68, 7, 100, -71, -82, -13, -94, 10, -19, 18, -3, -31, 8, -48, -84, -12, -1, 126, 101, 79, -111, -21, -28, 121, 123, -5, 67, -6, -95, 0, 107, 97, -15, 111, -75, 82, -7, 33, 69, 55, 59, -103, 29, 9, -43, -89, 84, 93, 30, 46, 94, 75, -105, 114, 73, -34, -59, 96, -46, 45, 16, -29, -8, -54, 51, -104, -4, 125, 81, -50, -41, -70, 39, -98, -78, -69, -125, -120, 1, 49, 50, 17, -115, 91, 47, -127, 60, 99, -102, 35, 86, -85, 105, 34, 38, -56, -109, 58, 77, 118, -83, -10, 76, -2, -123, -24, -60, -112, -58, 124, 53, 4, 108, 74, -33, -22, -122, -26, -99, -117, -67, -51, -57, -128, -80, 19, -45, -20, 127, -64, -25, 70, -23, 88, -110, 44, -73, -55, 22, 83, 13, -42, 116, 109, -97, 32, 95, -30, -116, -36, 57, 12, -35, 31, -47, -74, -113, 92, -107, -72, -108, 62, 113, 65, 37, 27, 106, -90, 3, 14, -52, 72, 21, 41, 56, 66, 28, -63, 40, -39, 25, 54, -77, 117, -18, 87, -16, -101, -76, -86, -14, -44, -65, -93, 78, -38, -119, -62, -81, 110, 43, 119, -32, 71, 122, -114, 42, -96, 104, 48, -9, 103, 15, 11, -118, -17};

    public static byte[] generatePearsonHash(byte[] data, int hashLength) {
        if (hashLength <= 0) {
            return new byte[0];
        }
        if (data == null || data.length <= 0) {
            return new byte[hashLength];
        }
        byte[] hh = new byte[hashLength];
        for (int j = 0; j < hashLength; ++j) {
            byte h = pearson[data[0] + j & 0xFF];
            for (int i = 1; i < data.length; ++i) {
                h = pearson[(h ^ data[i & 0xFF]) & 0xFF];
            }
            hh[j] = h;
        }
        return hh;
    }

    public static byte[] generatePearsonHash(byte[] data, int index, int length, int hashLength) {
        if (hashLength <= 0) {
            return new byte[0];
        }
        if (data == null || data.length <= 0) {
            return new byte[hashLength];
        }
        if (index < 0) {
            length += index;
            index = 0;
        }
        if (length > data.length - index) {
            length = data.length - index;
        }
        if (length <= 0) {
            return new byte[hashLength];
        }
        byte[] hh = new byte[hashLength];
        for (int j = 0; j < hashLength; ++j) {
            byte h = pearson[data[index] + j & 0xFF];
            for (int i = 1; i < length; ++i) {
                h = pearson[(h ^ data[index + i & 0xFF]) & 0xFF];
            }
            hh[j] = h;
        }
        return hh;
    }
}

