/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.sockets;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import lowentry.ue4.classes.internal.CachedTime;
import lowentry.ue4.classes.sockets.SimpleSocketClient;
import lowentry.ue4.classes.sockets.SimpleSocketServerClientHandler;
import lowentry.ue4.classes.sockets.SimpleSocketServerListener;
import lowentry.ue4.library.LowEntry;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroSelector;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroServer;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.events.PyroServerListener;

public class SimpleSocketServer
implements Iterable<SimpleSocketClient> {
    public static boolean IS_DEBUGGING = false;
    public static PrintStream DEBUGGING_PRINTSTREAM = System.out;
    private static final int NEW_CONNECTIONS_QUEUE_SIZE = 500;
    private static final int HANDSHAKE_TIMEOUT_MS = 30000;
    protected final PyroServer server;
    protected final Collection<SimpleSocketClient> clients = new LinkedHashSet<SimpleSocketClient>();
    protected final int serverPort;
    protected final SimpleSocketServerListener socketListener;
    protected long lastHandshakingClientHandlerValidation = CachedTime.millisSinceStart();
    protected final Collection<SimpleSocketServerClientHandler> handshakingClientHandlers = new LinkedHashSet<SimpleSocketServerClientHandler>();
    protected final String addressText;

    public static void setDebuggingEnabled() {
        IS_DEBUGGING = true;
    }

    public static void setDebuggingEnabled(PrintStream printstream) {
        IS_DEBUGGING = true;
        DEBUGGING_PRINTSTREAM = printstream;
    }

    public SimpleSocketServer(boolean acceptExternalConnections, int port, SimpleSocketServerListener listener) throws Exception {
        this.serverPort = port;
        this.socketListener = listener;
        PyroSelector selector = new PyroSelector();
        this.server = selector.listen(acceptExternalConnections, port, 500, this.createServerListener());
        this.addressText = this.getAddressText();
    }

    protected PyroServerListener createServerListener() {
        return client -> {
            SimpleSocketServer socketServer = this;
            SimpleSocketClient socketClient = new SimpleSocketClient(socketServer, client);
            SimpleSocketServerClientHandler clientHandler = new SimpleSocketServerClientHandler(this.socketListener, socketServer, socketClient);
            client.setListener(clientHandler);
            clientHandler.connectedClient(client);
        };
    }

    public void listen() {
        this.listen(100L);
    }

    public void listen(long eventTimeout) {
        this.server.selector().checkThread();
        if (eventTimeout <= 10L) {
            this.pyroListen(eventTimeout);
            this.handleHandshakingTimeouts();
            return;
        }
        long startTime = CachedTime.millisSinceStart();
        this.pyroListen(eventTimeout);
        long lastTime = CachedTime.millisSinceStart();
        long timeSpend = lastTime - startTime;
        while (timeSpend < eventTimeout - 10L) {
            this.pyroListen(eventTimeout - timeSpend);
            long newTime = CachedTime.millisSinceStart();
            if (newTime == lastTime) continue;
            lastTime = newTime;
            timeSpend = lastTime - startTime;
        }
        this.handleHandshakingTimeouts();
    }

    private void pyroListen(long eventTimeout) {
        for (long i = 1L; i <= eventTimeout; ++i) {
            try {
                this.server.selector().select(1L);
                continue;
            }
            catch (Exception e) {
                if (!IS_DEBUGGING) continue;
                DEBUGGING_PRINTSTREAM.println("[DEBUG] " + this + " listen caused an exception:");
                DEBUGGING_PRINTSTREAM.println(LowEntry.getStackTrace(e));
            }
        }
    }

    protected void handleHandshakingTimeouts() {
        long time = CachedTime.millisSinceStart();
        if (time - this.lastHandshakingClientHandlerValidation < 5000L) {
            return;
        }
        this.lastHandshakingClientHandlerValidation = time;
        Iterator<SimpleSocketServerClientHandler> iterator = this.handshakingClientHandlers.iterator();
        while (iterator.hasNext()) {
            SimpleSocketServerClientHandler clientHandler = iterator.next();
            if (time - clientHandler.handshakingStartTime < 30000L) {
                return;
            }
            if (IS_DEBUGGING) {
                byte[] handshake = clientHandler.handshakingPacket == null ? null : clientHandler.handshakingPacket.toByteArray();
                DEBUGGING_PRINTSTREAM.println("[DEBUG] " + clientHandler.socketClient + " was disconnected because the handshake took too long" + (String)(handshake == null ? "" : ", handshake so far was: " + LowEntry.bytesToHex(handshake) + " => " + LowEntry.bytesToStringLatin1(handshake).replaceAll("[\\p{C}]", "?")));
            }
            iterator.remove();
            clientHandler.disconnect();
        }
    }

    public void close() {
        if (this.server.selector().isNetworkThread()) {
            try {
                this.server.close();
            }
            catch (Exception exception) {}
        } else {
            this.server.selector().scheduleTask(() -> {
                try {
                    this.server.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    public void terminate() {
        if (this.server.selector().isNetworkThread()) {
            try {
                this.server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (SimpleSocketClient client : this) {
                client.disconnect();
            }
        } else {
            this.server.selector().scheduleTask(() -> {
                try {
                    this.server.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (SimpleSocketClient client : this) {
                    client.disconnect();
                }
            });
        }
    }

    public void terminateImmediately() {
        if (this.server.selector().isNetworkThread()) {
            try {
                this.server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (SimpleSocketClient client : this) {
                client.disconnectImmediately();
            }
        } else {
            this.server.selector().scheduleTask(() -> {
                try {
                    this.server.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (SimpleSocketClient client : this) {
                    client.disconnectImmediately();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<SimpleSocketClient> iterator() {
        ArrayList<SimpleSocketClient> copy;
        Collection<SimpleSocketClient> collection = this.clients;
        synchronized (collection) {
            copy = new ArrayList<SimpleSocketClient>(this.clients);
        }
        return copy.iterator();
    }

    public void forEachClient(Consumer<SimpleSocketClient> action) {
        this.forEach(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientCount() {
        Collection<SimpleSocketClient> collection = this.clients;
        synchronized (collection) {
            return this.clients.size();
        }
    }

    public PyroServer pyro() {
        return this.server;
    }

    public PyroSelector selector() {
        return this.server.selector();
    }

    public void execute(Runnable runnable) {
        if (this.server.selector().isNetworkThread()) {
            runnable.run();
        } else {
            this.server.selector().scheduleTask(runnable);
        }
    }

    public int getPort() {
        return this.serverPort;
    }

    public String getAddressText() {
        if (this.addressText != null) {
            return this.addressText;
        }
        if (this.server == null) {
            return "closed";
        }
        return this.server.getAddressText();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAddressText() + "]";
    }
}

