/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.sockets;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import lowentry.ue4.classes.sockets.LatentFunctionCall;
import lowentry.ue4.classes.sockets.SocketConnection;
import lowentry.ue4.classes.sockets.SocketConnectionListener;
import lowentry.ue4.classes.sockets.SocketTasks;
import lowentry.ue4.classes.sockets.ThreadedAsyncSocketConnectionListener;
import lowentry.ue4.classes.utility.ThreadSleeper;
import lowentry.ue4.libs.pyronet.craterstudio.util.concur.SimpleBlockingQueue;

public class ThreadedAsyncSocketConnection {
    private static int ID = 1;
    private static final Object idSynchronizer = new Object();
    protected final Object startSynchronizer = new Object();
    protected final ThreadSleeper reconnectSleeper = new ThreadSleeper();
    protected final ThreadSleeper startSleeper = new ThreadSleeper();
    protected final ThreadSleeper stopSleeper = new ThreadSleeper();
    protected final String host;
    protected final int portTcp;
    protected final int portUdp;
    protected final ThreadedAsyncSocketConnectionListener listener;
    protected volatile SocketConnection connection;
    protected volatile Object attachment;
    protected volatile boolean connected = false;
    protected volatile boolean run = true;
    protected final SimpleBlockingQueue<Runnable> tasks = new SimpleBlockingQueue();
    protected volatile boolean started = false;

    public ThreadedAsyncSocketConnection(String host, int portTcp, ThreadedAsyncSocketConnectionListener listener) {
        this.host = host;
        this.portTcp = portTcp;
        this.portUdp = 0;
        this.listener = listener;
    }

    public ThreadedAsyncSocketConnection(String host, int portTcp, int portUdp, ThreadedAsyncSocketConnectionListener listener) {
        this.host = host;
        this.portTcp = portTcp;
        this.portUdp = portUdp;
        this.listener = listener;
    }

    public ThreadedAsyncSocketConnection(String host, int portTcp, SocketConnectionListener listener) {
        this.host = host;
        this.portTcp = portTcp;
        this.portUdp = 0;
        this.listener = ThreadedAsyncSocketConnection.getWrappedListener(listener);
    }

    public ThreadedAsyncSocketConnection(String host, int portTcp, int portUdp, SocketConnectionListener listener) {
        this.host = host;
        this.portTcp = portTcp;
        this.portUdp = portUdp;
        this.listener = ThreadedAsyncSocketConnection.getWrappedListener(listener);
    }

    public static ThreadedAsyncSocketConnectionListener getWrappedListener(final SocketConnectionListener listener) {
        return new ThreadedAsyncSocketConnectionListener(){

            @Override
            public void connected(ThreadedAsyncSocketConnection threadedConnection, SocketConnection connection) {
                listener.connected(connection);
            }

            @Override
            public void disconnected(ThreadedAsyncSocketConnection threadedConnection, SocketConnection connection) {
                listener.disconnected(connection);
            }

            @Override
            public void receivedUnreliableMessage(ThreadedAsyncSocketConnection threadedConnection, SocketConnection connection, byte[] bytes) {
                listener.receivedUnreliableMessage(connection, bytes);
            }

            @Override
            public void receivedMessage(ThreadedAsyncSocketConnection threadedConnection, SocketConnection connection, byte[] bytes) {
                listener.receivedMessage(connection, bytes);
            }
        };
    }

    public void startAsync() {
        this.startAsync(5);
    }

    public void startAsync(int threadPriority) {
        this.start(false, threadPriority);
    }

    public void start() {
        this.start(5);
    }

    public void start(int threadPriority) {
        this.start(true, threadPriority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(boolean waitForStart, int threadPriority) {
        Object object = this.startSynchronizer;
        synchronized (object) {
            if (this.connection != null) {
                this.stop();
            }
            this.run = true;
            this.started = false;
            Thread thread = new Thread(() -> {
                PrivateSocketConnectionListener listenerWrapper = new PrivateSocketConnectionListener(this);
                this.connection = new SocketConnection(this.host, this.portTcp, this.portUdp, listenerWrapper);
                this.connected = this.connection.connect();
                this.started = true;
                this.startSleeper.wakeup();
                while (this.run) {
                    if (!this.connected) {
                        this.reconnectSleeper.sleep(1000L);
                        if (!this.run) break;
                        this.connected = this.connection.connect();
                    } else if (this.connection.isConnected()) {
                        this.connection.listen();
                    } else {
                        this.connected = false;
                    }
                    this.executePendingTasks();
                }
                while (this.connection.isConnected() && this.connection.pyro().hasDataEnqueued()) {
                    this.connection.listen(10L);
                }
                this.executePendingTasks();
                if (this.connected) {
                    this.connection.disconnect();
                    this.connected = false;
                    if (listenerWrapper.connectedWasCalled.getAndSet(false)) {
                        this.listener.disconnected(this, this.connection);
                    }
                }
                this.executePendingTasks();
                this.connection = null;
                this.stopSleeper.wakeup();
            }, "Threaded-Socket-Connection-Async-" + ThreadedAsyncSocketConnection.getNextId());
            thread.setDaemon(true);
            thread.setPriority(threadPriority);
            thread.start();
            if (waitForStart) {
                this.waitTillStarted();
            }
        }
    }

    public void waitTillStarted() {
        while (!this.started) {
            this.startSleeper.sleep(50L);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.startSynchronizer;
        synchronized (object) {
            return this.run;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAsync() {
        Object object = this.startSynchronizer;
        synchronized (object) {
            this.run = false;
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.startSynchronizer;
        synchronized (object) {
            this.run = false;
            this.wakeup();
            this.waitTillStopped();
        }
    }

    public void waitTillStopped() {
        while (this.connection != null) {
            this.stopSleeper.sleep(50L);
        }
    }

    protected void wakeup() {
        this.reconnectSleeper.wakeup();
        SocketConnection finalConnection = this.connection;
        if (finalConnection != null) {
            try {
                finalConnection.selector().wakeup();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void executePendingTasks() {
        Runnable task;
        while ((task = this.tasks.poll()) != null) {
            try {
                task.run();
            }
            catch (Exception cause) {
                cause.printStackTrace();
            }
        }
    }

    public void addTask(Runnable task) {
        if (task != null) {
            this.tasks.put(task);
        }
    }

    public InetSocketAddress getLocalAddress() {
        SocketConnection finalConnection = this.connection;
        if (finalConnection == null) {
            return null;
        }
        return finalConnection.getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        SocketConnection finalConnection = this.connection;
        if (finalConnection == null) {
            return null;
        }
        return finalConnection.getRemoteAddress();
    }

    public void sendUnreliableMessage(byte[] ... bytes) {
        SocketConnection finalConnection = this.connection;
        if (!this.connected || finalConnection == null) {
            return;
        }
        finalConnection.sendUnreliableMessage(bytes);
    }

    public void sendUnreliableMessage(byte[] bytes) {
        SocketConnection finalConnection = this.connection;
        if (!this.connected || finalConnection == null) {
            return;
        }
        finalConnection.sendUnreliableMessage(bytes);
    }

    public void sendUnreliableMessage(ByteBuffer bytes) {
        SocketConnection finalConnection = this.connection;
        if (!this.connected || finalConnection == null) {
            return;
        }
        finalConnection.sendUnreliableMessage(bytes);
    }

    public void sendMessage(byte[] ... bytes) {
        SocketConnection finalConnection = this.connection;
        if (!this.connected || finalConnection == null) {
            return;
        }
        finalConnection.sendMessage(bytes);
    }

    public void sendMessage(byte[] bytes) {
        SocketConnection finalConnection = this.connection;
        if (!this.connected || finalConnection == null) {
            return;
        }
        finalConnection.sendMessage(bytes);
    }

    public void sendFunctionCall(byte[] bytes, SocketConnection.FunctionCallListener functionCallListener) {
        SocketConnection finalConnection = this.connection;
        if (!this.connected || finalConnection == null) {
            if (functionCallListener != null) {
                this.tasks.put(new SocketTasks.FailedFunctionCallListener(functionCallListener, finalConnection));
            }
            return;
        }
        finalConnection.sendFunctionCall(bytes, functionCallListener);
    }

    public void sendFunctionCall(float timeout, byte[] bytes, SocketConnection.FunctionCallListener functionCallListener) {
        SocketConnection finalConnection = this.connection;
        if (!this.connected || finalConnection == null) {
            if (functionCallListener != null) {
                this.tasks.put(new SocketTasks.FailedFunctionCallListener(functionCallListener, finalConnection));
            }
            return;
        }
        finalConnection.sendFunctionCall(timeout, bytes, functionCallListener);
    }

    public LatentFunctionCall sendLatentFunctionCall(byte[] bytes, SocketConnection.LatentFunctionCallListener functionCallListener) {
        SocketConnection finalConnection = this.connection;
        if (!this.connected || finalConnection == null) {
            if (functionCallListener != null) {
                this.tasks.put(new SocketTasks.FailedLatentFunctionCallListener(functionCallListener, finalConnection));
            }
            return new LatentFunctionCall(finalConnection, true);
        }
        return finalConnection.sendLatentFunctionCall(bytes, functionCallListener);
    }

    public LatentFunctionCall sendLatentFunctionCall(float timeout, byte[] bytes, SocketConnection.LatentFunctionCallListener functionCallListener) {
        SocketConnection finalConnection = this.connection;
        if (!this.connected || finalConnection == null) {
            if (functionCallListener != null) {
                this.tasks.put(new SocketTasks.FailedLatentFunctionCallListener(functionCallListener, finalConnection));
            }
            return new LatentFunctionCall(finalConnection, true);
        }
        return finalConnection.sendLatentFunctionCall(timeout, bytes, functionCallListener);
    }

    public SocketConnection connection() {
        return this.connection;
    }

    public String toString() {
        SocketConnection finalConnection = this.connection;
        if (finalConnection != null) {
            return finalConnection.toString();
        }
        return super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getNextId() {
        Object object = idSynchronizer;
        synchronized (object) {
            int id = ID++;
            if (ID >= Integer.MAX_VALUE) {
                ID = 1;
            }
            return id;
        }
    }

    private static final class PrivateSocketConnectionListener
    implements SocketConnectionListener {
        public final ThreadedAsyncSocketConnection self;
        public final AtomicBoolean connectedWasCalled = new AtomicBoolean(false);

        public PrivateSocketConnectionListener(ThreadedAsyncSocketConnection self) {
            this.self = self;
        }

        @Override
        public void connected(SocketConnection connection) {
            if (!this.self.run) {
                return;
            }
            this.connectedWasCalled.set(true);
            this.self.tasks.put(new SocketTasks.ConnectedThreadedAsyncSocketConnection(this.self, this.self.listener, connection));
        }

        @Override
        public void disconnected(SocketConnection connection) {
            if (!this.self.run) {
                return;
            }
            if (!this.connectedWasCalled.getAndSet(false)) {
                return;
            }
            this.self.tasks.put(new SocketTasks.DisconnectedThreadedAsyncSocketConnection(this.self, this.self.listener, connection));
        }

        @Override
        public void receivedUnreliableMessage(SocketConnection connection, byte[] bytes) {
            if (!this.self.run) {
                return;
            }
            this.self.tasks.put(new SocketTasks.ReceivedUnreliableMessageThreadedAsyncSocketConnection(this.self, this.self.listener, connection, bytes));
        }

        @Override
        public void receivedMessage(SocketConnection connection, byte[] bytes) {
            if (!this.self.run) {
                return;
            }
            this.self.tasks.put(new SocketTasks.ReceivedMessageThreadedAsyncSocketConnection(this.self, this.self.listener, connection, bytes));
        }
    }
}

