/*
 * Decompiled with CFR 0.152.
 */
package lowentry.ue4.classes.sockets;

import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import lowentry.ue4.classes.sockets.SimpleSocketConnection;
import lowentry.ue4.classes.sockets.SimpleSocketConnectionListener;
import lowentry.ue4.classes.sockets.SocketTasks;
import lowentry.ue4.classes.sockets.ThreadedSimpleSocketConnectionListener;
import lowentry.ue4.classes.utility.ThreadSleeper;
import lowentry.ue4.libs.pyronet.craterstudio.util.concur.SimpleBlockingQueue;
import lowentry.ue4.libs.pyronet.jawnae.pyronet.PyroException;

public class ThreadedSimpleSocketConnection {
    private static int ID = 1;
    private static final Object idSynchronizer = new Object();
    protected final Object startSynchronizer = new Object();
    protected final ThreadSleeper reconnectSleeper = new ThreadSleeper();
    protected final ThreadSleeper startSleeper = new ThreadSleeper();
    protected final ThreadSleeper stopSleeper = new ThreadSleeper();
    protected final Thread networkThread;
    protected final String host;
    protected final int port;
    protected final ThreadedSimpleSocketConnectionListener listener;
    protected volatile SimpleSocketConnection connection;
    protected volatile Object attachment;
    protected volatile boolean connected = false;
    protected volatile boolean run = true;
    protected final SimpleBlockingQueue<Runnable> tasks = new SimpleBlockingQueue();
    protected volatile boolean started = false;

    public ThreadedSimpleSocketConnection(String host, int port, ThreadedSimpleSocketConnectionListener listener) {
        this.networkThread = Thread.currentThread();
        this.host = host;
        this.port = port;
        this.listener = listener;
    }

    public ThreadedSimpleSocketConnection(String host, int port, SimpleSocketConnectionListener listener) {
        this.networkThread = Thread.currentThread();
        this.host = host;
        this.port = port;
        this.listener = ThreadedSimpleSocketConnection.getWrappedListener(listener);
    }

    public static ThreadedSimpleSocketConnectionListener getWrappedListener(final SimpleSocketConnectionListener listener) {
        return new ThreadedSimpleSocketConnectionListener(){

            @Override
            public void connected(ThreadedSimpleSocketConnection threadedConnection, SimpleSocketConnection connection) {
                listener.connected(connection);
            }

            @Override
            public void disconnected(ThreadedSimpleSocketConnection threadedConnection, SimpleSocketConnection connection) {
                listener.disconnected(connection);
            }

            @Override
            public void receivedPacket(ThreadedSimpleSocketConnection threadedConnection, SimpleSocketConnection connection, byte[] bytes) {
                listener.receivedPacket(connection, bytes);
            }
        };
    }

    public void startAsync() {
        this.startAsync(5);
    }

    public void startAsync(int threadPriority) {
        this.start(false, threadPriority);
    }

    public void start() {
        this.start(5);
    }

    public void start(int threadPriority) {
        this.start(true, threadPriority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(boolean waitForStart, int threadPriority) {
        Object object = this.startSynchronizer;
        synchronized (object) {
            if (this.connection != null) {
                this.stop();
            }
            this.run = true;
            this.started = false;
            Thread thread = new Thread(() -> {
                PrivateSimpleSocketConnectionListener listenerWrapper = new PrivateSimpleSocketConnectionListener(this);
                this.connection = new SimpleSocketConnection(this.host, this.port, listenerWrapper);
                this.connected = this.connection.connect();
                this.started = true;
                this.startSleeper.wakeup();
                while (this.run) {
                    if (!this.connected) {
                        this.reconnectSleeper.sleep(1000L);
                        if (!this.run) break;
                        this.connected = this.connection.connect();
                        continue;
                    }
                    if (this.connection.isConnected()) {
                        this.connection.listen();
                        continue;
                    }
                    this.connected = false;
                }
                while (this.connection.isConnected() && this.connection.pyro().hasDataEnqueued()) {
                    this.connection.listen(10L);
                }
                if (this.connected) {
                    this.connection.disconnect();
                    this.connected = false;
                    if (listenerWrapper.connectedWasCalled.getAndSet(false)) {
                        this.tasks.put(new SocketTasks.DisconnectedThreadedSimpleSocketConnection(this, this.listener, this.connection));
                    }
                }
                this.connection = null;
                this.stopSleeper.wakeup();
            }, "Threaded-Simple-Socket-Connection-" + ThreadedSimpleSocketConnection.getNextId());
            thread.setDaemon(true);
            thread.setPriority(threadPriority);
            thread.start();
            if (waitForStart) {
                this.waitTillStarted();
            }
        }
    }

    public void waitTillStarted() {
        while (!this.started) {
            this.startSleeper.sleep(50L);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.startSynchronizer;
        synchronized (object) {
            return this.run;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAsync() {
        Object object = this.startSynchronizer;
        synchronized (object) {
            this.run = false;
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.startSynchronizer;
        synchronized (object) {
            this.run = false;
            this.wakeup();
            this.waitTillStopped();
        }
    }

    public void waitTillStopped() {
        while (this.connection != null) {
            this.stopSleeper.sleep(50L);
        }
    }

    protected void wakeup() {
        this.reconnectSleeper.wakeup();
        SimpleSocketConnection finalConnection = this.connection;
        if (finalConnection != null) {
            try {
                finalConnection.selector().wakeup();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void executePendingTasks() {
        Runnable task;
        if (this.networkThread != Thread.currentThread()) {
            throw new PyroException("call from outside the network-thread");
        }
        while ((task = this.tasks.poll()) != null) {
            try {
                task.run();
            }
            catch (Exception cause) {
                cause.printStackTrace();
            }
        }
    }

    public void addTask(Runnable task) {
        if (task != null) {
            this.tasks.put(task);
        }
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public <T> T getAttachment() {
        return (T)this.attachment;
    }

    public boolean hasAttachment() {
        return this.attachment != null;
    }

    public InetSocketAddress getLocalAddress() {
        SimpleSocketConnection finalConnection = this.connection;
        if (finalConnection == null) {
            return null;
        }
        return finalConnection.getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        SimpleSocketConnection finalConnection = this.connection;
        if (finalConnection == null) {
            return null;
        }
        return finalConnection.getRemoteAddress();
    }

    public void sendPacket(byte[] ... bytes) {
        SimpleSocketConnection finalConnection = this.connection;
        if (!this.connected || finalConnection == null) {
            return;
        }
        finalConnection.sendPacket(bytes);
    }

    public void sendPacket(byte[] bytes) {
        SimpleSocketConnection finalConnection = this.connection;
        if (!this.connected || finalConnection == null) {
            return;
        }
        finalConnection.sendPacket(bytes);
    }

    public SimpleSocketConnection connection() {
        return this.connection;
    }

    public String toString() {
        SimpleSocketConnection finalConnection = this.connection;
        if (finalConnection != null) {
            return finalConnection.toString();
        }
        return super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getNextId() {
        Object object = idSynchronizer;
        synchronized (object) {
            int id = ID++;
            if (ID >= Integer.MAX_VALUE) {
                ID = 1;
            }
            return id;
        }
    }

    private static final class PrivateSimpleSocketConnectionListener
    implements SimpleSocketConnectionListener {
        public final ThreadedSimpleSocketConnection self;
        public final AtomicBoolean connectedWasCalled = new AtomicBoolean(false);

        public PrivateSimpleSocketConnectionListener(ThreadedSimpleSocketConnection self) {
            this.self = self;
        }

        @Override
        public void connected(SimpleSocketConnection connection) {
            if (!this.self.run) {
                return;
            }
            this.connectedWasCalled.set(true);
            this.self.tasks.put(new SocketTasks.ConnectedThreadedSimpleSocketConnection(this.self, this.self.listener, connection));
        }

        @Override
        public void disconnected(SimpleSocketConnection connection) {
            if (!this.self.run) {
                return;
            }
            if (!this.connectedWasCalled.getAndSet(false)) {
                return;
            }
            this.self.tasks.put(new SocketTasks.DisconnectedThreadedSimpleSocketConnection(this.self, this.self.listener, connection));
        }

        @Override
        public void receivedPacket(SimpleSocketConnection connection, byte[] bytes) {
            if (!this.self.run) {
                return;
            }
            this.self.tasks.put(new SocketTasks.ReceivedPacketThreadedSimpleSocketConnection(this.self, this.self.listener, connection, bytes));
        }
    }
}

