/*
 * Decompiled with CFR 0.152.
 */
package com.spacenetwork.nativeio;

import com.spacenetwork.nativeio.CLibrary;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;

public class TunDevice {
    private static final int TUNSETIFF = 1074025674;
    private static final short IFF_TUN = 1;
    private static final short IFF_NO_PI = 4096;
    private final FileInputStream in;
    private final FileOutputStream out;
    private final String name;

    public TunDevice(String ifaceName) throws IOException {
        RandomAccessFile tunFile = new RandomAccessFile("/dev/net/tun", "rw");
        int fd = TunDevice.getFd(tunFile.getFD());
        byte[] ifr = new byte[40];
        byte[] nameBytes = ifaceName.getBytes(StandardCharsets.US_ASCII);
        System.arraycopy(nameBytes, 0, ifr, 0, Math.min(nameBytes.length, 15));
        ifr[16] = 1;
        Memory mem = new Memory((long)ifr.length);
        mem.write(0L, ifr, 0, ifr.length);
        int ret = CLibrary.INSTANCE.ioctl(fd, 1074025674, (Pointer)mem);
        if (ret < 0) {
            throw new IOException("Failed to create tun interface");
        }
        this.in = new FileInputStream(tunFile.getFD());
        this.out = new FileOutputStream(tunFile.getFD());
        this.name = ifaceName;
        System.out.println("TUN device created: " + ifaceName);
    }

    private static int getFd(FileDescriptor fd) throws IOException {
        try {
            Field field = FileDescriptor.class.getDeclaredField("fd");
            field.setAccessible(true);
            return field.getInt(fd);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IOException("Unable to access FileDescriptor.fd", e);
        }
    }

    public byte[] readPacket() throws IOException {
        byte[] buf = new byte[2048];
        int len = this.in.read(buf);
        if (len < 0) {
            throw new EOFException("TUN read returned EOF");
        }
        byte[] pkt = new byte[len];
        System.arraycopy(buf, 0, pkt, 0, len);
        return pkt;
    }

    public void writePacket(byte[] data) throws IOException {
        this.out.write(data);
        this.out.flush();
    }

    public String getName() {
        return this.name;
    }
}

