/*
 * Decompiled with CFR 0.152.
 */
package com.spacenetwork.tunnel;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.snaju.nebula.SpaceSDK;
import com.snaju.nebula.entities.plugin.SpacePlugin;
import com.spacenetwork.mcs.entites.utils.HeaderUtils;
import com.spacenetwork.mcs.services.RedisService;
import com.spacenetwork.mcs.services.SNCommService;
import com.spacenetwork.nativeio.TunDevice;
import fr.devnied.bitlib.BytesUtils;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.CRC32C;
import javax.crypto.Cipher;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.core.Pcaps;

public class TunnelPlugin
extends SpacePlugin {
    private static final int SRS3_TYPE_IP = 1;
    private static final int SRS_IV_LEN = 12;
    private static final int SRS_TAG_LEN = 16;
    private static final int SRS_HEADER_LEN = 2;
    private static final int SRS_CRC_LEN = 4;
    private static final int PLAINTEXT_LEN = 998;
    private static final int MAX_PAYLOAD = 996;
    private static final int FINAL_FRAME_LEN = 1030;
    private static final String TUN_INTERFACE_NAME = "tun_nebula";
    private static final String PHYSICAL_INTERFACE_NAME = "enp1s0f0";
    private static final String MY_PHYSICAL_IP = "10.10.10.65";
    private static final String TUN_GATEWAY_IP = "169.254.1.1";
    private DatagramSocket udpSocket;
    private TunDevice tun;
    private PcapHandle pcapHandle;
    private ExecutorService executor;
    private volatile boolean running = false;
    private byte[] myPhysicalIpBytes;

    public void onEnable() {
        try {
            System.out.println("Initializing SRS-3 Uplink (Java Encoder: header+AES-GCM+CRC32C)\u2026");
            this.setupTun();
            this.setupPcap();
            this.myPhysicalIpBytes = InetAddress.getByName(MY_PHYSICAL_IP).getAddress();
            this.udpSocket = new DatagramSocket();
            this.running = true;
            this.executor = Executors.newFixedThreadPool(2);
            this.executor.submit(this::uplinkThread);
            this.executor.submit(this::downlinkThread);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.onDisable();
        }
    }

    public TunnelSession getSessionFromTargetIp(String targetIp) throws Exception {
        String token = (String)((RedisService)SpaceSDK.inject(RedisService.class)).getRedisConnection().sync().hget((Object)"tunnel:uplink", (Object)targetIp);
        return this.getSessionFromToken(token);
    }

    public TunnelSession getSessionFromVirtualIp(String virtualIp) throws Exception {
        String token = (String)((RedisService)SpaceSDK.inject(RedisService.class)).getRedisConnection().sync().hget((Object)"tunnel:downlink", (Object)virtualIp);
        return this.getSessionFromToken(token);
    }

    public TunnelSession getSessionFromToken(String token) throws Exception {
        if (token == null) {
            return null;
        }
        if (!((RedisService)SpaceSDK.inject(RedisService.class)).getRedisConnection().sync().hexists((Object)"tunnel:map", (Object)token).booleanValue()) {
            return null;
        }
        String jsonRaw = (String)((RedisService)SpaceSDK.inject(RedisService.class)).getRedisConnection().sync().hget((Object)"tunnel:map", (Object)token);
        JsonObject json = JsonParser.parseString((String)jsonRaw).getAsJsonObject();
        String id = json.get("id").getAsString();
        String virtual = json.get("virtual").getAsString();
        String target = json.get("target").getAsString();
        JsonObject crypto = json.getAsJsonObject("crypto");
        String txKeyHex = crypto.get("tx").getAsString();
        String rxKeyHex = crypto.get("rx").getAsString();
        return new TunnelSession(id, virtual, target, txKeyHex, rxKeyHex);
    }

    public List<TunnelSession> getAllSessions() throws Exception {
        ArrayList<TunnelSession> sessions = new ArrayList<TunnelSession>();
        for (String jsonRaw : ((RedisService)SpaceSDK.inject(RedisService.class)).getRedisConnection().sync().hgetall((Object)"tunnel:map").values()) {
            JsonObject json = JsonParser.parseString((String)jsonRaw).getAsJsonObject();
            String id = json.get("id").getAsString();
            String virtual = json.get("virtual").getAsString();
            String target = json.get("target").getAsString();
            String rxKeyHex = json.has("rxKey") ? json.get("rxKey").getAsString() : "0000000000000000000000000000000000000000000000000000000000000000";
            String txKeyHex = json.has("txKey") ? json.get("txKey").getAsString() : "0000000000000000000000000000000000000000000000000000000000000000";
            sessions.add(new TunnelSession(id, virtual, target, rxKeyHex, txKeyHex));
        }
        return sessions;
    }

    private void setupTun() throws Exception {
        this.tun = new TunDevice(TUN_INTERFACE_NAME);
        this.runCommand("ip", "link", "set", TUN_INTERFACE_NAME, "up");
        this.runCommand("ip", "link", "set", "dev", TUN_INTERFACE_NAME, "mtu", "1400");
        this.runCommand("ip", "addr", "add", "169.254.1.1/32", "dev", TUN_INTERFACE_NAME);
        this.runCommand("ip", "route", "add", "10.1.0.0/16", "dev", TUN_INTERFACE_NAME);
    }

    private void setupPcap() throws PcapNativeException, NotOpenException {
        PcapNetworkInterface nif = Pcaps.getDevByName((String)PHYSICAL_INTERFACE_NAME);
        this.pcapHandle = nif.openLive(65536, PcapNetworkInterface.PromiscuousMode.PROMISCUOUS, 10);
        this.pcapHandle.setFilter("dst host 10.10.10.65", BpfProgram.BpfCompileMode.OPTIMIZE);
    }

    private static byte[] hexToBytes(String s) {
        int len = s.length();
        byte[] out = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            out[i / 2] = (byte)(Character.digit(s.charAt(i), 16) << 4 | Character.digit(s.charAt(i + 1), 16));
        }
        return out;
    }

    private void uplinkThread() {
        block5: {
            try {
                Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
                SecureRandom random = new SecureRandom();
                CRC32C crc32c = new CRC32C();
                while (this.running) {
                    byte[] rawData = this.tun.readPacket();
                    if (rawData == null || rawData.length <= 4 || (rawData[4] & 0xF0) != 64) continue;
                    ByteBuffer ipWrapper = ByteBuffer.wrap(rawData);
                    ipWrapper.position(4);
                    ByteBuffer ipPacket = ipWrapper.slice();
                    String dstIp = this.getIpString(ipPacket, 16);
                    TunnelSession session = this.getSessionFromVirtualIp(dstIp);
                    if (session == null) continue;
                    ipPacket.position(12);
                    ipPacket.put(this.myPhysicalIpBytes);
                    ipPacket.position(16);
                    ipPacket.put(session.targetIpBytes);
                    ipPacket.rewind();
                    this.recalcChecksums(ipPacket);
                    byte[] ipBytes = new byte[ipPacket.remaining()];
                    ipPacket.get(ipBytes);
                    if (ipBytes.length > 996) {
                        System.out.println("Dropping oversize IP packet: " + ipBytes.length + " bytes (max " + 996 + ")");
                        continue;
                    }
                    ByteBuffer plaintext = ByteBuffer.allocate(998);
                    plaintext.order(ByteOrder.BIG_ENDIAN);
                    short header = HeaderUtils.buildSrs3Header((int)1, (int)ipBytes.length);
                    plaintext.putShort(header);
                    plaintext.put(ipBytes);
                    while (plaintext.position() < 998) {
                        plaintext.put((byte)0);
                    }
                    byte[] pt = plaintext.array();
                    ((SNCommService)SpaceSDK.inject(SNCommService.class)).routeOut(pt, 1);
                    ((SNCommService)SpaceSDK.inject(SNCommService.class)).routeOut(pt, 2);
                    ((SNCommService)SpaceSDK.inject(SNCommService.class)).routeOut(pt, 3);
                }
            }
            catch (Exception e) {
                if (!this.running) break block5;
                e.printStackTrace();
            }
        }
    }

    private void downlinkThread() {
        byte[] buffer = new byte[1030];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        System.out.println("\u2705 Downlink Thread Started. Listening on " + this.udpSocket.getLocalAddress().getHostAddress() + ":" + this.udpSocket.getLocalPort());
        while (this.running) {
            try {
                System.out.println("Inside downlink thread");
                this.udpSocket.receive(packet);
                InetAddress senderAddress = packet.getAddress();
                String senderIp = senderAddress.getHostAddress();
                int senderPort = packet.getPort();
                int receivedLength = packet.getLength();
                System.out.printf("\u2b07\ufe0f Received UDP reply from %s:%d. Length: %d bytes.\n", senderIp, senderPort, receivedLength);
                byte[] receivedData = Arrays.copyOf(buffer, receivedLength);
                System.out.println("HEX DUMP: " + BytesUtils.bytesToString((byte[])receivedData));
                System.out.println("------------------------------------------");
                ((SNCommService)SpaceSDK.inject(SNCommService.class)).routeIn(receivedData);
            }
            catch (SocketTimeoutException senderAddress) {
            }
            catch (SocketException e) {
                if (!this.running) break;
                System.err.println("Socket closed unexpectedly: " + e.getMessage());
                break;
            }
            catch (Exception e) {
                if (!this.running) continue;
                System.err.println("Downlink processing error: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void recalcChecksums(ByteBuffer ipData) {
        this.recalcIPv4Checksum(ipData);
        this.recalcTransportChecksum(ipData);
    }

    private void recalcIPv4Checksum(ByteBuffer ipData) {
        int pos = ipData.position();
        ipData.putShort(pos + 10, (short)0);
        int headerLen = (ipData.get(pos) & 0xF) * 4;
        long sum = 0L;
        for (int i = 0; i < headerLen; i += 2) {
            sum += (long)(ipData.getShort(pos + i) & 0xFFFF);
        }
        while (sum >> 16 > 0L) {
            sum = (sum & 0xFFFFL) + (sum >> 16);
        }
        ipData.putShort(pos + 10, (short)(sum ^ 0xFFFFFFFFFFFFFFFFL));
    }

    private void recalcTransportChecksum(ByteBuffer ipData) {
        int pos = ipData.position();
        int hlen = (ipData.get(pos) & 0xF) * 4;
        int proto = ipData.get(pos + 9) & 0xFF;
        if (proto == 6) {
            this.recalcTCP(ipData, pos, hlen);
        } else if (proto == 17) {
            this.recalcUDP(ipData, pos, hlen);
        }
    }

    private void recalcTCP(ByteBuffer ipData, int pos, int hlen) {
        int cks = pos + hlen + 16;
        ipData.putShort(cks, (short)0);
        int ipTotal = ipData.getShort(pos + 2) & 0xFFFF;
        int tcpLen = ipTotal - hlen;
        long sum = 0L;
        sum += (long)(ipData.getShort(pos + 12) & 0xFFFF);
        sum += (long)(ipData.getShort(pos + 14) & 0xFFFF);
        sum += (long)(ipData.getShort(pos + 16) & 0xFFFF);
        sum += (long)(ipData.getShort(pos + 18) & 0xFFFF);
        sum += 6L;
        sum += (long)tcpLen;
        for (int i = 0; i < tcpLen; i += 2) {
            if (i + 1 >= tcpLen) {
                sum += (long)((ipData.get(pos + hlen + i) & 0xFF) << 8);
                continue;
            }
            sum += (long)(ipData.getShort(pos + hlen + i) & 0xFFFF);
        }
        while (sum >> 16 > 0L) {
            sum = (sum & 0xFFFFL) + (sum >> 16);
        }
        ipData.putShort(cks, (short)(sum ^ 0xFFFFFFFFFFFFFFFFL));
    }

    private void recalcUDP(ByteBuffer ipData, int pos, int hlen) {
        int cks = pos + hlen + 6;
        ipData.putShort(cks, (short)0);
        int ipTotal = ipData.getShort(pos + 2) & 0xFFFF;
        int udpLen = ipTotal - hlen;
        long sum = 0L;
        sum += (long)(ipData.getShort(pos + 12) & 0xFFFF);
        sum += (long)(ipData.getShort(pos + 14) & 0xFFFF);
        sum += (long)(ipData.getShort(pos + 16) & 0xFFFF);
        sum += (long)(ipData.getShort(pos + 18) & 0xFFFF);
        sum += 17L;
        sum += (long)udpLen;
        for (int i = 0; i < udpLen; i += 2) {
            if (i + 1 >= udpLen) {
                sum += (long)((ipData.get(pos + hlen + i) & 0xFF) << 8);
                continue;
            }
            sum += (long)(ipData.getShort(pos + hlen + i) & 0xFFFF);
        }
        while (sum >> 16 > 0L) {
            sum = (sum & 0xFFFFL) + (sum >> 16);
        }
        int checksum = (int)(sum ^ 0xFFFFFFFFFFFFFFFFL);
        if (checksum == 0) {
            checksum = 65535;
        }
        ipData.putShort(cks, (short)checksum);
    }

    private String getIpString(ByteBuffer data, int offset) {
        return (data.get(offset) & 0xFF) + "." + (data.get(offset + 1) & 0xFF) + "." + (data.get(offset + 2) & 0xFF) + "." + (data.get(offset + 3) & 0xFF);
    }

    private void runCommand(String ... cmd) throws Exception {
        new ProcessBuilder(cmd).inheritIO().start().waitFor();
    }

    public void onDisable() {
        this.running = false;
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (this.pcapHandle != null) {
            this.pcapHandle.close();
        }
        try {
            this.runCommand("ip", "link", "set", TUN_INTERFACE_NAME, "down");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class TunnelSession {
        final String id;
        final byte[] virtualIpBytes;
        final byte[] targetIpBytes;
        final String txKey;
        final String rxKey;

        public TunnelSession(String id, String virtualIp, String targetIp, String txKey, String rxKey) throws Exception {
            this.id = id;
            this.virtualIpBytes = InetAddress.getByName(virtualIp).getAddress();
            this.targetIpBytes = InetAddress.getByName(targetIp).getAddress();
            this.txKey = txKey;
            this.rxKey = rxKey;
        }
    }
}

